import java.io.*;
import java.util.Hashtable;
import java.util.ArrayList;

public class TransitiveClosure
{
	final private int MAX_DOMS = 100;

	private int num_doms;
	private boolean dom_mtrix[][];
	private boolean visited_dom[];
	private Hashtable<String,Integer> dom_id;
	private String domains[];

	public TransitiveClosure(String details_file)
	{
		num_doms = 0;

		dom_mtrix = new boolean[MAX_DOMS][MAX_DOMS];
		visited_dom = new boolean[MAX_DOMS];
		dom_id = new Hashtable<String,Integer>();
		domains = new String[MAX_DOMS];

		createDomMtrix(details_file);
	}

	public void createDomMtrix(String details_file)
	{
		try 
		{
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(details_file)));
        		String line = null;
 
        		while((line = br.readLine()) != null) 
			{
				String doms[] = line.split(":");
				for(int i=0; i<doms.length; i++)
					if(!dom_id.containsKey(doms[i]))
					{
						dom_id.put(doms[i],num_doms);
						domains[num_doms] = doms[i];
						num_doms++;
					}

				int dom1 = dom_id.get(doms[0]);
				int dom2 = dom_id.get(doms[1]);
				dom_mtrix[dom1][dom2] = dom_mtrix[dom2][dom1] = true;
			}
			br.close(); 
		} 
		catch(IOException ioe) 
		{
			System.out.println(ioe.toString());
		}
		//System.out.println("Sanity check:: #Domains: "+num_doms);
	}

	public void computeTransitiveClosure()
	{
		ArrayList<Integer> arr = new ArrayList<Integer>();
		for(int i=0; i<num_doms; i++)
		{
			if(visited_dom[i])
				continue;

			String txt = "";
			arr.add(i);
			visited_dom[i] = true;
			while(!arr.isEmpty())
			{
				int s = arr.get(0);
				txt += domains[s] + " ";
				arr.remove(0);
				for(int n=0; n<num_doms; n++)
					if(dom_mtrix[s][n] && !visited_dom[n])
					{
						arr.add(n);	
						visited_dom[n] = true;
					}
			}	
			//System.out.println(txt);
			String tokens[] = txt.split(" ");
			for(int x=0; x<tokens.length-1; x++)
			for(int y=x+1; y<tokens.length; y++)
				System.out.println(tokens[x]+":"+tokens[y]);
		}
	}

	public static void main(String args[])
	{
		String filename = args[0];
		//System.out.println("filename = " + filename);
		TransitiveClosure tc = new TransitiveClosure(filename);
		tc.computeTransitiveClosure();
	}
}
