#!/usr/bin/python
#
#======================================================================================================================================
# ad hoc script: 
# Enter 3x3 confusion matrix (actual class are rows, predicted class are columns).
# Prints accuracy, precision, recall F1 score.
#
#======================================================================================================================================

import getopt, glob, math, os, sys
from collections import defaultdict

from time import time

#import os
import sys
import numpy as np

from sklearn import metrics
from sklearn.cross_validation import train_test_split
from sklearn.linear_model import SGDClassifier
from sklearn.metrics import confusion_matrix
from sklearn.metrics import f1_score
from sklearn.metrics import precision_score
from sklearn.metrics import recall_score
from sklearn.metrics import classification_report
from sklearn.naive_bayes import BernoulliNB, MultinomialNB
from sklearn.linear_model import RidgeClassifier
from sklearn.svm import LinearSVC
from sklearn.linear_model import Perceptron, LogisticRegression
from sklearn.neighbors import KNeighborsClassifier
from sklearn.neighbors import NearestCentroid
from sklearn.ensemble import RandomForestClassifier
from sklearn.tree import DecisionTreeClassifier
from scipy import sparse



matrix = np.zeros((3,3))

print 'Enter confusion matrix: \n'

for i in range(0,3):
	line = raw_input("");
	x, y, z = line.split(" ")
	matrix[i][0] = int(x)
	matrix[i][1] = int(y)
	matrix[i][2] = int(z)


actual_class = []
pred_class = []

for i in range(0,3):
	for j in range(0,3):
		num = int(matrix[i][j])
		for pt in range(0,num):
			actual_class.append(i)
			pred_class.append(j)

#print '\n\n' 
#print str(len(actual_class))
#print actual_class

#print '\n\n' 
#print str(len(pred_class))
#print pred_class
#print '\n\n' 

pr = precision_score(actual_class, pred_class, average="weighted")
re = recall_score(actual_class, pred_class, average="weighted")
f1 = f1_score(actual_class, pred_class, average="weighted")
print("Precision: %0.3f, Recall: %0.3f, F1: %0.3f " % (pr, re, f1))


