;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; sal-class-definitions.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Mon Jul 8
;; Last Modified By: Ashish Tiwari
;; Last Modified On: Fri Jul 16
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY
;; 05.27.03: unary-application is inherited from pvs::unary-application.
;;	Two other similar changes, marked by ASHISH.
;; 05.29.07: type -> declared-type in expression, var-decl, simple-decl
;; 05.29.07: numeral.number -> numeral.this-number
;; 05.29.07: pvs:module replaced by sal-declaration in context
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; In order to represent SAL transition systems (and modules), one needs
;; some more structure (basically class definitions) than are available
;; in PVS. In particular, the idea is to use PVS:EXPR for encoding SAL
;; expressions, but, anything ABOVE that: like, assignments, transitions,
;; modules, etc, is represented using a SAL class. All class definitions
;; that will be used in SAL package are defined here. 
;; Contains class definitions to represent SAL transition systems in PVS.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :sal)

(defvar *fast-make-instance-makers* (make-hash-table :test #'eq))
(defun fast-make-instance (ttype)
  (let ((maker (or (gethash ttype *fast-make-instance-makers*)
		   (setf (gethash ttype *fast-make-instance-makers*)
			 (compile nil `(lambda () (make-instance
						      ',ttype)))))))
    (funcall maker)))
(defmacro declare-make-instance (ttype)
  `(setf (gethash ',ttype *fast-make-instance-makers*)
    (compile nil '(lambda () (make-instance ',ttype)))))


(defcl sal-syntax ()
  comment
  place)

;;; Contexts

(defcl context (sal-syntax)
  (id :type symbol :parse t)
  (formals :type list :parse t)
  context-body)

(defcl parameters (sal-syntax)
  type-decls
  var-decls)

(defcl type-decls (sal-syntax)
  declarations)

(defcl var-decls (sal-syntax)
  declarations)

(defcl formal-type-decl (type-decl formal-decl))

(defcl formal-const-decl (formal-decl))

(defcl type-decl (sal-declaration))

(defcl var-decl (sal-declaration)	;; removed pvs:var-decl
  id
  declared-type
  chain?)

(defcl bind-decl (var-decl binding name-expr)
  (chain? :parse t))

(defcl context-body (sal-syntax)
  declarations)

;;; A mixin
(defcl sal-declaration (sal-syntax)
  (id :type symbol :parse t)
  (formals :type list :parse t)
  module
  (refers-to :type list)
  (referred-by :type list :fetch-as nil)
  (chain? :type symbol :parse t)
  (typechecked? :type symbol)
  (visible? :type symbol)
  (generated :documentation "a list of declarations")
  (generated-by :documentation "a declaration instance")
  (semi :parse t)
  (tcc-form :fetch-as nil :ignore t)
  typecheck-time)

(defcl constant-declaration (sal-declaration)
  (definition :parse t)
  def-axiom
  declared-type
  (eval-info :fetch-as nil))

(defcl type-declaration (sal-declaration)
  (type-expr :parse t)
  (contains :parse t))

(defcl context-declaration (sal-declaration)
  context-name)

(defcl context-name (sal-syntax name))

(defcl actual-parameters (sal-syntax)
  actual-types
  actual-exprs)

(defcl actual-types (sal-syntax)
  actual-types)

(defcl actual-exprs (sal-syntax)
  actual-exprs)

(defcl module-declaration (sal-declaration)
  parameters
  module)

(defcl module-parameter-decl (var-decl))

;;; Modules

;;; The modref is the module-instance reference to the given module, e.g.,
;;; for the declaration  m: MODULE = (m1 || m2) [] m3
;;;   modref of "(m1 || m2) [] m3" is "m"
;;;   modref of "(m1 || m2)" is "m_1"
;;;   modref of "m1" is "m_1_1"
;;; This is primarily used for printout purposes.

(defcl module (sal-syntax)
  modref
  typechecked?
  parens
  input-decls
  output-decls
  global-decls
  local-decls
  state-type
  state-constants
  init-predicate
  trans-relation)

(defcl base-module (module)
  declarations)

;;; In the following, the -decls class is the list of all the declarations
;;; of that section.  These are converted to the corresponding -decl form.
;;; This way, the declarations of a base module are flattened.

;;; A mixin class to easily recognize state-variables
(defcl state-var-decls (sal-syntax)
  var-decls)

(defcl input-decls (state-var-decls))

(defcl output-decls (state-var-decls))

(defcl global-decls (state-var-decls))

(defcl local-decls (state-var-decls))

(defcl state-var-decl (var-decl)
  section-last?)

(defcl observed-var-decl (state-var-decl))

(defcl controlled-var-decl (state-var-decl))

(defcl input-decl (observed-var-decl))

(defcl output-decl (controlled-var-decl))

(defcl global-decl (controlled-var-decl observed-var-decl))

(defcl local-decl (controlled-var-decl))

(defcl def-decl (sal-syntax)
  definitions)

(defcl init-decl (sal-syntax)
  definitions-or-commands)

(defcl trans-decl (sal-syntax)
  definitions-or-commands)

(defcl simple-definition (sal-syntax)
  lhs
  rhs-definition)

(defcl rhs-expression (sal-syntax)
  expression)

(defcl rhs-selection (sal-syntax)
  expression)

(defcl forall-definition (sal-syntax)
  bindings
  definitions)

(defcl guarded-command (sal-syntax)
  label
  guard
  assignments
  last-assignment?)

(defcl labeled-command (guarded-command))

(defcl guard (sal-syntax)
  expression)

(defcl assignments (sal-syntax)
  definitions)

(defcl some-commands (sal-syntax)
  commands)

(defcl multi-command (sal-syntax)
  var-decls
  some-command)

(defcl composition (module)
  module1
  module2)

(defcl synchronous-composition (composition))

(defcl asynchronous-composition (composition))

(defcl multi-composition (module)
  var-decl
  module)

(defcl multi-synchronous (multi-composition))

(defcl multi-asynchronous (multi-composition))

(defcl hiding (module)
  ids
  module)

(defcl new-output (module)
  var-decls
  module)

(defcl renaming (module)
  with
  renames
  module)

(defcl rename (sal-syntax)
  lhs
  rhs)

(defcl with-module (module)
  new-var-decls
  module)

(defcl new-var-decls (var-decls))

(defcl module-instance (module)
  mod-name
  actuals)

(defcl module-actuals (sal-syntax)
  actuals)

(defcl module-name (sal-syntax)
  mod-decl
  id)

(defcl qualified-module-name (sal-syntax)
  context-name)

(defcl observe-module (synchronous-composition))

;; ASHISH: SPecific to hybridsal (copied from hybrid-sal.lisp)
(defcl invar-decl (sal-syntax)
  expression)

(defcl initfor-decl (sal-syntax)
  expression)


;;; Types

(defcl type-def (sal-syntax))
(defcl scalar-type (type-def)
  id
  (identifiers :type list))

(defcl scalar-element (sal-syntax)
  id)

(defcl datatype (type-def))

(defcl adt-constructor (sal-syntax)
  (recognizer :type symbol :parse t)
  (ordnum :type fixnum))
(defcl simple-constructor (adt-constructor)
  (id :type symbol :parse t)
  (arguments :documentation "a list of adtdecls" :parse t)
  con-decl
  rec-decl
  acc-decls)
(defcl constructor (simple-constructor sal-syntax))

(defcl accessor (sal-syntax)
  (bind-decl :documentation "Keeps a corresponding bind-decl"))

(defcl type-expression (sal-syntax)
  (parens :initform 0 :parse t)
  print-type
  from-conversion
  (free-variables :ignore t :initform 'unbound :fetch-as 'unbound)
  (free-parameters :ignore t :initform 'unbound :fetch-as 'unbound)
  nonempty?)

(defcl type-name (name type-expression)
  adt
  uninterpreted?)

(defcl qualified-type-name (type-name)
  context-name)

(defcl subtype (type-expression)
  (supertype :parse t)
  (top-type :fetch-as nil :ignore t)
  predicate)
(defcl subrange (subtype)
  lower-bound
  upper-bound)

(defcl funtype (type-expression)
  (domain :parse t)
  (range :parse t))
(defcl array-type (funtype type-expression))

(defcl function-type (funtype type-expression))

(defcl tuple-type (type-expression)
  (types :parse t)
  generated?)

(defcl record-type (type-expression)
  (fields :parse t)
  dependent?)

(defcl simple-decl (sal-syntax)
  (id :parse t)
  (declared-type :parse t))
(defcl binding (simple-decl))
(defcl field-declaration (binding name sal-syntax)
  (chain? :parse t))

(defcl module-state-type (record-type)
  module)

;;; Expressions

(defcl expression (sal-syntax)
  (parens :initform 0 :parse t)
  declared-type
  (free-variables :ignore t :initform 'unbound :fetch-as 'unbound)
  (free-parameters :ignore t :initform 'unbound :fetch-as 'unbound)
  from-macro)

(defcl module-init (expression)
  predicate
  module)

(defcl module-trans (expression)
  relation
  module)

(defcl next-operator (expression)
  name)

(defcl name (sal-syntax)
  (mod-id :parse t)
  (library :parse t)
  (actuals :parse t)
  (id :parse t)
  (mappings :parse t)
  resolutions)
(defcl name-expr (expression name))

(defcl qualified-name-expr (name-expr)
  context-name)

(defcl application (expression)
  (operator :parse t)
  (argument :parse t))

(defcl infix-application (application))	;; ASHISH: Added pvs:infix-application

(defcl unary-application (application))	;; ASHISH: Added pvs:unary-application

(defcl propositional-application (application))

(defcl negation (propositional-application))
(defcl unary-negation (negation unary-application))

(defcl conjunction (propositional-application))
(defcl infix-conjunction (conjunction infix-application))

(defcl disjunction (propositional-application))
(defcl infix-disjunction (disjunction infix-application))

(defcl implication (propositional-application))
(defcl infix-implication (implication infix-application))

(defcl iff-or-boolean-equation (application))

(defcl iff (iff-or-boolean-equation propositional-application))
(defcl infix-iff (iff infix-application))

(defcl equation (application))
(defcl infix-equation (equation infix-application))	;; ASHISH: Added pvs:infix-equation

(defcl boolean-equation (iff-or-boolean-equation equation))
(defcl infix-boolean-equation (boolean-equation infix-equation))

(defcl disequation (application))
(defcl infix-disequation (disequation infix-application))


(defcl array-selection (application))

(defcl field-application (expression)
  id
  actuals
  argument)
(defcl record-selection (expression field-application)
  record
  field)

(defcl projection-application (expression)
  id
  actuals
  index
  argument)
(defcl tuple-selection (projection-application)
  tuple
  index)

(defcl record-literal (expression)
  (assignments :parse t))

(defcl assignment (sal-syntax)
  (arguments :parse t)
  (expression :parse t))
(defcl record-entry (assignment)
  id)

(defcl tuple-expr (expression)
  (exprs :parse t))
(defcl tuple-literal (tuple-expr))

(defcl update-expr (expr)
  (expression :parse t)
  (assignments :parse t))
(defcl update-expression (update-expr)
  updateposition
  value)

(defcl array-literal (lambda-expr))

(defcl index-var-decl (var-decl))

(defcl lambda-abstraction (expression lambda-expr))

(defcl quant-expr (binding-expr))
(defcl quantified-expression (expression quant-expr)
  quantifier)

(defcl let-expression (expression)
  declarations
  expr)

(defcl let-declaration (var-decl)
  value)

(defcl lambda-expr (binding-expr))
(defcl binding-expr (expression)
  (bindings :parse t)
  (expression :parse t)
  (commas? :parse t)
  (chain? :parse t))
(defcl set-pred-expr (lambda-expr))

(defcl set-list-expr (lambda-expr)
  expressions)

(defcl conditional (application))

(defcl if-expr (application))
(defcl chained-if-expr (if-expr))
(defcl chained-conditional (chained-if-expr))

(defcl numeral (expression)
  (this-number :parse t))

(defcl identifier (sal-syntax)
  id)

;;; Assertions

(defcl assertion-declaration (sal-declaration)
  assertion-form
  assertion)

(defcl assertion-form (sal-syntax)
  form)

(defcl assertion-proposition (sal-syntax)
  operator
  assertions)

(defcl quantified-assertion (sal-syntax)
  quantifier
  var-decls
  assertion)

(defcl module-models (sal-syntax)
  module
  assertion)

(defcl module-implements (sal-syntax)
  module1
  module2)

;;; Support classes
;; ASHISH: CHECK ; was inherited from pvs:const-decl
(defcl sal-state-const-decl (sal-syntax)
  sal-module)

;; ============================================================================
;; ASHISH: Support functions...
(defun sal-error (obj msg &rest args)
  (declare (ignore obj))
  (format t "sal-error: ~?" msg args)
  (break))

(defmethod ps-eq ((ope name-expr) symb)
  (eq (op2symbol ope) symb))
(defmethod ps-eq ((ope t) symb)
  (declare (ignore symb))
  nil)
(defmethod op2symbol ((ope name-expr))
  (id ope))

(defmethod args1 ((ee application))
  (args1 (argument ee)))
(defmethod args2 ((ee application))
  (args2 (argument ee)))
(defmethod args ((ee application) n)
  (args (argument ee) n))
(defmethod args1 ((ee tuple-literal))
  (car (exprs ee)))
(defmethod args2 ((ee tuple-literal))
  (cadr (exprs ee)))
(defmethod args ((ee tuple-literal) n)
  (nth n (exprs ee)))
(defmethod args1 ((ee t))
  (sal-error t "args1 called on non-tuple-literal~%"))
(defmethod args2 ((ee t))
  (sal-error t "args2 called on non-tuple-literal~%"))
(defmethod args ((ee t) n)
  (sal-error t "args called on non-tuple-literal with ~a~%" n))

(defmethod binary? ((ee application))
  (binary? (argument ee)))
(defmethod binary? ((ee tuple-literal))
  (binary? (exprs ee)))
(defmethod binary? ((ee list))
  (eq (length ee) 2))
(defmethod binary? ((ee t))
  (sal-error t "binary? called on unknown type~%"))
;; ============================================================================

