;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; defcl.lisp -- This provides the a macro that expands into defclass plus
;;               the methods 
;; Author          : Sam Owre
;; Created On      : Tue May 31 01:36:04 1994
;; Last Modified By: Sam Owre
;; Last Modified On: Fri Jul  1 14:02:27 1994
;; Update Count    : 14
;; Status          : Beta
;; 
;; HISTORY 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :sal)

#+cmu
(defmethod slot-exists-p-using-class (c o s)
  (declare (ignore c o s))
  nil)

#+gcl
(eval-when (eval compile load)
  (defmacro ignore-errors (&body forms)
    `(progn ,@forms)))


(defvar *slot-info* nil
  "An association list mapping classes to superclasses, immediate
unignored slots, saved-slots, and unsaved-slots.")


(defmacro defcl (name classes &rest args)
  (setf args (mapcar #'(lambda (a) (if (consp a) a (list a))) args))
  `(progn ,@(mapcar #'(lambda (a)
			#+allegro `(declaim (ftype (function (t)
				     ,(cadr (member :type a))) ,(car a)))
			;#+allegro `(declaim (function ,(car a) (t)
					     ;,(cadr (member :type a))))
			#-allegro `(proclaim '(function ,(car a) (t)
					       ,(cadr (member :type a)))))
		    (remove-if-not #'(lambda (a) (member :type a))
		      args))
    (defclass ,name ,classes
      ,(mapcar #'(lambda (a)
		   (setq a (remove-keyword
			    :parse
			    (remove-keyword
			     :ignore
			     (remove-keyword
			      :ignorc
			      (remove-keyword
			       :fetch-as a)))))
		   (append a (list :accessor (car a)
				   :initarg (car a)
				   :initarg (intern (string (car a))
						    'keyword))
			   (unless (memq :initform a)
			     (list :initform nil))))
	       args))
    (declare-make-instance ,name)
    ;; (proclaim '(inline ,(intern (format nil "~a?" name))))
    (defun ,(intern (format nil "~a?" name)) (obj)
      (typep obj ',name))
    (eval-when (eval compile load)
      (setq *slot-info*
	    (cons (cons ',name
			'(,classes ,args))
		   (delete (assoc ',name *slot-info*)
			   *slot-info*))))
    (defmethod untc*
	,@(when classes (list :around))
	((obj ,name))
	,@(when classes (list '(call-next-method)))
	,@(mapcar #'(lambda (a)
		      (let ((slot (car a)))
			(if (cadr (memq :parse a))
			    `(untc* (slot-value obj ',slot))
			    `(setf (slot-value obj ',slot)
			      ,(cadr (memq :initform a))))))
		  args))
    ))


; (defmacro defcl* (name classes &rest args)
;   (let ((cl (macroexpand `(defcl ,name ,classes ,@args))))
;     (eval (second cl))
;     (eval (sixth cl))   ;; updates *slot-info*
;     (append cl
; 	    (generate-defcl-methods (list name))
; 	    (generate-update-fetched-methods (list name)))))

; (defvar *classes-done* nil)
; (defvar *methods-collected* nil)

; (defun generate-defcl-methods (names)
;   (let ((*classes-done* nil)
; 	(*methods-collected* nil))
;     (generate-defcl-methods* names)
;     *methods-collected*))

; (defun generate-defcl-methods* (names)
;   (when names
;     (let* ((name (car names))
; 	   (class (find-class name)))
;       (unless (memq name *classes-done*)
; 	(push name *classes-done*)
; 	(setq *methods-collected*
; 	      (nconc *methods-collected*
; 		     (list (generate-copy-method name)
; 			   (generate-store-object*-method name)
; 			   ;;(generate-update-fetched-method name)
; 			   )))
; 	(generate-defcl-methods* (mapcar #'class-name
; 				   (class-direct-subclasses class)))))
;     (generate-defcl-methods* (cdr names))))

; (defun generate-update-fetched-methods (names)
;   (let ((*classes-done* nil)
; 	(*methods-collected* nil))
;     (generate-update-fetched-methods* names)
;     (nreverse *methods-collected*)))

; (defun generate-update-fetched-methods* (names)
;   (when names
;     (let* ((name (car names))
; 	   (class (find-class name)))
;       (unless (memq name *classes-done*)
; 	(push name *classes-done*)
; 	(push (generate-update-fetched-method name) *methods-collected*)
; 	(generate-update-fetched-methods* (mapcar #'class-name
; 					    (class-direct-subclasses class)))))
;     (generate-update-fetched-methods* (cdr names))))


;;; lcopy is a lazy copy that only makes a copy if there is a difference

(defun lcopy (obj &rest initargs)
  (if (loop for (key val) on initargs by #'cddr
	    always (eq (slot-value obj key) val))
      obj
      (apply #'copy obj initargs)))

(eval-when (compile load eval)
  (defun remove-keyword (key list)
    (let ((tail (member key list)))
      (if tail
	  (append (ldiff list tail) (cddr tail))
	  list))))

;;; Grabbed off the net, from jmorrill@bbn.com (Jeff Morrill)
;;; Not used, but may come in handy.

;(defmethod shallow-copy ((object standard-object))
;  (let ((copy (make-instance (class-of object))))
;    (dolist (slotd (class-slots (class-of object)))
;       (let ((name (slot-definition-name slotd)))
;         (setf (slot-value copy name) (slot-value object name))))
;    copy))

;(defmethod eequal (obj1 obj2)
;  (equal obj1 obj2))

#+allegro
(defun memq (elt list)
  (member elt list :test #'eq))

(defun file-older (file1 file2)
  (let ((time1 (file-write-date file1))
	(time2 (file-write-date file2)))
    (or (null time1)
	(null time2)
	(<= time1 time2))))
