;; start "mlisp" (allegro CL)
(defun my-getenv (name &optional default)
    #+CMU
    (let ((x (assoc name ext:*environment-list*
                    :test #'string=)))
      (if x (cdr x) default))
    #-CMU
    (or
     #+allegro (sys:getenv name)
     #+Allegro (sys:getenv name)
     #+CLISP (ext:getenv name)
     #+ECL (si:getenv name)
     #+SBCL (sb-unix::posix-getenv name)
     #+LISPWORKS (lispworks:environment-variable name)
     default))

(defvar *sal-path* (my-getenv "PWD"))
(defvar *load-path* '("typechecker" "abstractor"))
(export '(*sal-path*))

;(defun lf (str)
  ;;(compile-file str)
  ;(load str))

(defmacro lf (file)
  `(make-file ,file))

(defun make-file (file)
  (let* ((source (make-file-name file))
	 (bin (make-pathname :defaults source :type "fasl")))
    (unless (probe-file source)
      (format t "~%File ~a does not exist~%" source))
    (when (compiled-file-older-than-source? source bin)
      (compile-file source :output-file bin))
    (load bin)))

(defun make-file-name (file)
  (let* ((name file)
	 (type (or (pathname-type file) "lisp")))
   (dolist (dir *load-path*)
     (let* ((defaults (or (probe-file (format nil "~a/~a/"
						  *sal-path* dir))
				    
		          (directory-p dir)))
		      
	    (path (make-pathname :name name :type type
					   :defaults defaults)))
		 
       (when (probe-file path)
	 (return-from make-file-name path))))
   (error "File ~a.~a cannot be found in *load-path*" name type)))

(defun compiled-file-older-than-source? (sourcefile binfile)
  (or (not (probe-file binfile))
      (file-older binfile sourcefile)))

(defun file-older (file1 file2)
  (let ((time1 (file-write-date file1))
        (time2 (file-write-date file2)))
    (or (null time1) (null time2) (<= time1 time2))))

;; Load Basic Parser and Typechecer for HybridSAL
(lf "defpackage")	;; define :sal pkg
(lf "defcl")		;; macro defcl
(lf "sal-class-definitions")	;; classes
(lf "sal-parse")		;; sal-parse
(lf "sal-unparse")		;; pp
(lf "sal-typecheck")
(lf "sal-extension")

;; Load the Hybrid Abstractor
(lf "polyrep/polyrep")
(lf "polyrep/sal-pvs2polyrep")
(lf "dp/decide2_0")
(lf "dp/feas")
(lf "composition/defpackage")
(lf "composition/hsal-abs-mksal")
(lf "composition/sal-hybrid-files")

(lf "composition/sal-extension")
(lf "composition/hsal-abs-db")
(lf "composition/hsal-abs-sat")

(lf "composition/hsal-abs-real")
(lf "composition/hsal-abs-fmla")
(lf "composition/hsal-compose")

;; Piecewise Code
(lf "piecewise/hsal-abs-piecewise")
(lf "piecewise/hsal-abs-pc-sat")


;; Here is how to use the program after loading:
;;(setq ctxt (sal-parse "examples/SimpleThermo3"))
;;(setq ctxt (typecheck* ctxt))
;;(abstract ctxt 'control)
;; OR simply call (abstract "examples/SimpleThermo3" 'control)
