;; Start mlisp, load "load.sal" and then 
;; cut-and-paste the following commands.
;; See also examples/README

;; Testing the hybrid abstractor
(tpl:setq-default *package* (find-package :sal))
(tpl:setq-default *print-escape* nil)
(setq *print-escape* nil)
(in-package :sal)

;; This should run w/o error and produce the
;; file SimpleThermo3ABS.sal
;(abstract "examples/SimpleThermo3" 'control)

;; This does the same, except it also 
;; abstracts ALL the properties in the i/p file
;(abstract "examples/SimpleThermo3" 'control :property 'all)
;; This can be model-checked using sal-smc
;; sal-smc -v 3 SimpleThermo3ABS correct
;; The model-checker should show "proved".

;; This does the same, except it also 
;; adds ONE more polynomial in the abstraction.
(abstract "examples/SimpleThermo3" 'control :property 'all :pols '("x - 50"))
;; The model-checker will still prove the property.

;; The second example
(abstract "examples/robot2" 'system :property 'all)
;; This can be model-checked using sal-smc
;; sal-smc -v 3 Robot2ABS correct
;; The model-checker should show "proved".

;; The third example
(abstract "examples/Aircraft" 'twoaircraft :property 'all)

(abstract "examples/satsv3" 'threeaircraft :property 'all)

(abstract "examples/lacv4" 'cell :property 'all)
