;;;;;;;;;;;;;;;;;;;;;;;;;;* -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vim: syntax=lisp
;; hsal-remove-scalars.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Mon Jul 01, 2002
;; Last Modified By: Ashish Tiwari
;; Last Modified On: Tue Jul 02, 2002
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY :
;; 07/05/02: Transform a .sal file to another .sal file, removing
;; 	the enumeration type and replacing them by BOOLEANS.
;; 12/31/02: Defined sal2sal-transform-decl1 on initfor-decl (trivial)
;; any enumeration variables, not just "state"....
;; Mar24,03: Added setf chain? t
;; Jul24,03: mk-sal-abstract-file1 copied here.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :sal)

;; External functions of this file
(defun sal2sal-enum2bool (filename)
  (let* ((salctxt (sal2sal-transform filename))
	 (comment "%% Automatically generated by sal2salenum2bool~%")
	 (f (make-pathname :defaults filename :type "1.sal"))
	 (basename (pathname-name f)))
    (mk-sal-abstract-file1 basename comment salctxt 
	:text "translated context" :kind "2.sal")))

;; Read in the .sal file, and remove the ENUMERATION types.
;; Assume that the .sal file was created by hsif-parse.
;; Assume that "filename" is a pathname!
(defun sal2sal-transform (sal-file)
  (let* (;(sal-file (make-pathname :defaults filename :type "1.sal"))
    	 (salctxt (cond ((sal::file-exists-p sal-file)
	   		 (sal-parse sal-file))
	  		(t (sal::sal-error sal-file "File not found"))))
	 (*v2v-db* nil)
	 (*n* 0))
    (declare (special *v2v-db* *n*))
    (sal2sal-transform-ctxt salctxt)))

;; remove white spaces and translate-hsif-to-sal*
(defun sal2sal-transform-ctxt (salctxt)
  (let* ((ctxtbody (context-body salctxt))
	 (typedecls (loop for i in ctxtbody if (scalar-type-decl? i) collect i))
	 (idrest (loop for i in typedecls collect (cons (id i) (identifiers (type-expr i)))))
  	 (newdecls (loop for i in ctxtbody
			 if (assertion-declaration? i) collect (sal2sal-transform-assertion i idrest)
		   	 if (module-declaration? i) collect (sal2sal-transform-moddecl i idrest)
		   	 if (and (not (assertion-declaration? i))
			   	 (not (module-declaration? i))
				 ;; (not (type-decl? i))
			   	 (not (scalar-type-decl? i))) collect i))
	 (ctxtid (id salctxt))
	 (params (mk-sal-parameters nil))
	 (newbody (apply #'mk-sal-contextbody nil newdecls)))
    (mk-sal-context nil ctxtid params newbody)))

;; info is a list of (id s1 s2), where id is STATETYPEk
;; and s1,s2 are symbols in the type STATETYPEk.
(defun sal2sal-transform-moddecl (moddecl info)
  (let* ((module (module moddecl))
	 (vardecls (apply #'mk-sal-vardecls nil (parameters moddecl)))
	 (modname (mk-sal-nameexpr nil (id moddecl)))
	 (newmodule (sal2sal-transform-module module info)))
  (mk-sal-moduledeclaration nil modname vardecls newmodule)))

(defmethod sal2sal-transform-module ((module base-module) info)
  (let* ((olddecls (declarations module))
	 (scalar-decls (loop for i in olddecls if (scalar-var-decl? i info) collect i)))
	 ;;(statetype (declared-type statedecl))
	 ;;(statetypeid (id statetype))
	 ;;(newinfo (find-if #'(lambda(x) (eq (car x) statetypeid)) info))
	 ;;(stateids (cdr newinfo))
    (update-global-var2var-db scalar-decls info)
    (let* ((newdecls0 (enum2bool-var-decls scalar-decls))
	   (newdecls1 (loop for i in olddecls collect 
			(sal2sal-transform-decl1 i info)))
	   (newdecls2 (remove-if #'null (nconc newdecls0 newdecls1))))
      (apply #'mk-sal-basemodule nil newdecls2))))

(defmethod sal2sal-transform-module ((module asynchronous-composition) info)
  (declare (ignore info))
  module)

(defmethod sal2sal-transform-module ((module synchronous-composition) info)
  (declare (ignore info))
  module)

(defmethod sal2sal-transform-module ((decl t) info)
  (declare (ignore info))
   (format t "PANIC: What kind of a module is this? MISSING code.~%")
   (break))

;; info: from here on is a list of ids, like (s2 s3 s4)
;; amap: list-of-('s2 ('b1.true) ('b2.false))
(defmethod sal2sal-transform-decl1 ((vardecl var-decl) info)
  (if (scalar-var-decl? vardecl info) nil vardecl))

(defmethod sal2sal-transform-decl1 ((idecl init-decl) info)
  (let* ((cmds (definitions-or-commands idecl))
	 (newcommands (loop for i in cmds collect (sal2sal-transform-decl2 i info)))
	 (gcs (loop for i in newcommands if (sal:guarded-command? i) collect i))
	 (defs (loop for i in newcommands if (not (sal:guarded-command? i)) collect i))
    	 (ngcs (if gcs (apply #'mk-sal-somecommands nil gcs)))
	 (ndefs (loop for i in defs append (if (listp i) i (list i)))))
    (apply #'mk-sal-initdecl nil (if gcs (cons ngcs ndefs) ndefs))))

  ;idecl		;; CHECK CHECK -- CHANGE THIS LATER

(defmethod sal2sal-transform-decl1 ((invar invar-decl) info)
  (let* ((invariant (expression invar))
	 (newinvariant (sal2sal-transform-expr invariant info)))
    (setf (expression invar) newinvariant)
    invar))

(defmethod sal2sal-transform-decl1 ((defn def-decl) info)
  (let* ((defns (definitions defn))
	 (newdefns (loop for i in defns collect (sal2sal-transform-decl2 i info))))
    (apply #'mk-sal-defdecl nil newdefns)))

(defmethod sal2sal-transform-decl1 ((idecl initfor-decl) info)
  (declare (ignore info))
  (format t "Can't handle init-formulas, check output~%")
  idecl)		;; CHECK CHECK -- CHANGE THIS LATER

(defmethod sal2sal-transform-decl1 ((transdecl trans-decl) info)
  (let* ((cmds (definitions-or-commands transdecl))
	 (newcommands (loop for i in cmds collect 
				(sal2sal-transform-decl2 i info)))
	 (gcs (loop for i in newcommands if (sal:guarded-command? i) collect i))
    	 (ngcs (if gcs (apply #'mk-sal-somecommands nil gcs)))
	 (gpos (position-if #'sal:guarded-command? newcommands))
	 (defs (loop for i in newcommands as j upfrom 0 if 
		(or (not (sal:guarded-command? i)) (eq j gpos)) collect i)))
    (if gpos (setf (nth gpos defs) ngcs))
    (apply #'mk-sal-transdecl nil defs)))

;; info: list of stateids (s2 s3 s4)
;; amap: enum2bool map: list-of-(s2 b1 b2) etc
(defmethod sal2sal-transform-decl2 ((gc guarded-command) info)
  (let* ((guard (guard gc))		;; expression
	 (assgns (assignments gc))	;; list of simple-definitions
	 (expr (expression guard))
	 (newexpr (sal2sal-transform-expr expr info))
	 (newguard (mk-sal-guard nil newexpr))
	 (newassgns1 (loop for i in assgns collect (sal2sal-transform-decl2 i info)))
	 (newassgns2 (loop for i in newassgns1 append (if (listp i) i (list i))))
	 (newassignments (apply #'mk-sal-assignments nil newassgns2)))
    (mk-sal-guardedcommand nil newguard newassignments)))

(defmethod sal2sal-transform-decl2 ((defn simple-definition) info)
  (declare (special *v2v-db*))
  (let* ((lhs (lhs defn))
	 (rhs (rhs-definition defn))
	 (lhsid (if (next-operator? lhs) (id (name lhs)) (id lhs))))
    (if (assoc lhsid *v2v-db*)
	(let* ((stateid (id rhs))
	       (bits-dot-amap (cdr (assoc lhsid *v2v-db*)))
	       (amap (cdr bits-dot-amap))
	       (bits (car bits-dot-amap))
	       (base2-number (cdr (assoc stateid amap))))
	  ;(break)
	  (num2defns base2-number bits (next-operator? lhs)))
	(let* ((new-rhs (sal2sal-transform-expr* rhs info)))
	  (if (null new-rhs) defn
	      (mk-sal-simpledefinition nil lhs new-rhs))))))

(defun sal2sal-transform-assertion (assertion info)
  (let* ((modmodels (assertion assertion))
	 (newmodmodels (sal2sal-transform-modmodels modmodels info)))
    (setf (assertion assertion) newmodmodels)
    assertion))

(defun sal2sal-transform-modmodels (modmodels info)
  (let* ((fmla (assertion modmodels))
	 (newfmla (sal2sal-transform-expr fmla info)))
    (setf (assertion modmodels) newfmla)
    modmodels))

(defun sal2sal-transform-expr (expr info)
  (let ((answer (sal2sal-transform-expr* expr info)))
    (if (null answer) expr answer)))

(defmethod sal2sal-transform-expr* :around ((expr application) info)
  (declare (special *v2v-db*))
  (declare (ignore info))
  (let ((answer (if (member (id (operator expr)) (list '= '/=))
      		    (let ((arg1 (car (exprs (argument expr)))))
		      (if (and (name-expr? arg1) (assoc (id arg1) *v2v-db*))
	    		  (let* ((value (id (cadr (exprs (argument expr)))))
	       	   		 (bits-dot-amap (cdr (assoc (id arg1) *v2v-db*)))
	       	   		 (amap (cdr bits-dot-amap))
	       	   		 (bits (car bits-dot-amap))
	       	   		 (base2-number (cdr (assoc value amap)))
	      		         (bool (num2salboolexpr base2-number bits)))
			    (if (eq (id (operator expr)) '=) bool
				(mk-sal-application nil (mk-sal-nameexpr nil 'NOT) 
				 (mk-sal-tupleliteral nil bool))))
	    	          (call-next-method)))
      		    (call-next-method))))
    (if (null answer) (return-from sal2sal-transform-expr* nil))
    (if (parens expr) (setf (parens answer) 1))
    answer))

(defmethod sal2sal-transform-expr* ((expr application) info)
  (let* ((op (operator expr))
	 (newarg (sal2sal-transform-expr* (argument expr) info))
	 (infix? (if (infix-application? expr) t nil)))
    (if (null newarg) nil
        (mk-sal-application (list 'infix? infix?) op newarg))))

(defmethod sal2sal-transform-expr* ((expr tuple-literal) info)
  (let ((new-exprs (loop for i in (exprs expr) collect (sal2sal-transform-expr* i info))))
    (if (every #'null new-exprs) nil
        (apply #'mk-sal-tupleliteral nil (loop for i in new-exprs as j in (exprs expr)
						collect (if i i j))))))
  
(defmethod sal2sal-transform-expr* ((expr chained-conditional) info)
  (let* ((cv1v2 (exprs (argument expr)))
	 (c1 (sal2sal-transform-expr* (car cv1v2) info))
	 (v1 (sal2sal-transform-expr* (cadr cv1v2) info))
	 (v2 (sal2sal-transform-expr* (caddr cv1v2) info)))
    (if (every #'null (list c1 v1 v2)) (return-from sal2sal-transform-expr* nil))
    (mk-sal-conditional '(elsif? t) (if c1 c1 (car cv1v2)) (if v1 v1 (cadr cv1v2)) 
				 (if v2 v2 (caddr cv1v2)))))

(defmethod sal2sal-transform-expr* ((expr conditional) info)
  (let* ((cv1v2 (exprs (argument expr)))
	 (c1 (sal2sal-transform-expr* (car cv1v2) info))
	 (v1 (sal2sal-transform-expr* (cadr cv1v2) info))
	 (v2 (sal2sal-transform-expr* (caddr cv1v2) info)))
    (if (every #'null (list c1 v1 v2)) (return-from sal2sal-transform-expr* nil))
    (mk-sal-conditional nil (if c1 c1 (car cv1v2)) (if v1 v1 (cadr cv1v2)) 
				 (if v2 v2 (caddr cv1v2)))))

(defmethod sal2sal-transform-expr* ((expr t) info)
  (declare (ignore info))
  nil)

;; --------------------------------------------------------------------
;; Miscellaneous Functions
;; --------------------------------------------------------------------
;; return (amap newstatedecl bits)
(defun enum2bool (stateids)
  (if (null (cdr stateids)) 
      (values nil nil)
      (multiple-value-bind (amap bits)
		(enum2bool* (cdr stateids) (list (list (car stateids))) nil)
				  ;;(cons 'b0 'FALSE)
			    ;;(list 'b0)		;; THIS SHOULD BE nil?????
	(values amap bits))))

;; remain: (s3 s4 s5)
;; done: reverse( (s3 (b1.FALSE)) (s4 (b1.TRUE)) (s5 (b1.FALSE)(b2.TRUE)) )
;; digits: (b1 b2 b3)
(defun enum2bool* (remain done digits)
  (if (null remain)
      (values done digits)
      (multiple-value-bind (nextnumber newdigit)
		(plus-one (cdar done) digits)
	(enum2bool* (cdr remain)
		(acons (car remain) nextnumber done) 
	        (nconc digits newdigit)))))

;; number: list of assocs (b1.T)  digit: (b1 b2 b3)
(defun plus-one (thisnumber digits &optional (res nil))
  (declare (special *n*))
  (if (null digits)
      (let* ((newdigit (intern (make-symbol (format nil "b~A" *n*)))))
	(setf *n* (+ *n* 1))
	(values (acons newdigit 'TRUE res) (list newdigit)))
      (if (eq (cdr (assoc (car digits) thisnumber)) 'TRUE) 
	  (plus-one thisnumber (cdr digits) (acons (car digits) 'FALSE res))
	  (plus-zero thisnumber (cdr digits) (acons (car digits) 'TRUE res)))))

(defun plus-zero (thisnumber digits res)
  (if (null digits) (values res nil)
      (plus-zero thisnumber (cdr digits)
		(acons  (car digits)
	       		(cdr (assoc (car digits) thisnumber))
	       		res))))

;; return sal-var-decls b1, b2, b3: BOOLEAN
(defun enum2bool-var-decls (scalar-var-decls)
  (mapcar #'enum2bool-var-decl scalar-var-decls))

(defun enum2bool-var-decl (scalar-var-decl)
  (declare (special *v2v-db*))
  (let ((db-entry (cdr (assoc (id scalar-var-decl) *v2v-db*))))
    (if (null db-entry) (progn (format t "ERROR: Global database *v2v-db* corrupt~%") (break)))
    (let ((all-decls (mapcar #'(lambda(x) (mk-sal-vardecl nil x	;; CHECK CHECK
						(mk-sal-typename nil 'BOOLEAN))) (car db-entry))))
      (loop for i in all-decls as j upfrom 1 do (if (< j (length all-decls)) (setf (sal::chain? i) t)))
      (apply (cond ((local-decl? scalar-var-decl)
		     #'mk-sal-localdecl) 
		   ((output-decl? scalar-var-decl)
		     #'mk-sal-outputdecl)
		   ((input-decl? scalar-var-decl)
		     #'mk-sal-inputdecl)
		   ((global-decl? scalar-var-decl)
		     #'mk-sal-globaldecl)
		   (t (format t "Var decl sh'd be local,global,input,or output!~%") (break)))
	nil all-decls))))

;; num-bits: 1 = 0; 2 = 1; 3 = 2; 4 = 2; 5 = 3; n = ceil(log_2 n)
;; obsolete
(defun num-bits (n)
  (cond ((eq n 1) 0)
	((eq n 2) 1)
	((oddp n) (num-bits (+ n 1)))
	(t (+ (num-bits (/ n 2)) 1))))

;; number: list of boolean ids. amap is used to find other boolean ids.
(defun num2salboolexpr (number bits &optional (res nil))
  (if (null bits)
      (if (null res) (mk-sal-nameexpr nil 'TRUE) res)
      (let* ((b1 (car bits))
	     (val1 (cdr (assoc b1 number)))
	     (val2 (if val1 val1 'FALSE))
	     (salb1 (mk-sal-nameexpr nil b1))
	     (salexpr1 (if (eq val2 'TRUE) salb1
			   (mk-sal-application '(infix? t)
				(mk-sal-nameexpr nil '=)
				(mk-sal-tupleliteral nil salb1
				  (mk-sal-nameexpr nil 'FALSE)))))
	     (salexpr2 (if (null res) salexpr1
			   (mk-sal-application '(infix? t)
				(mk-sal-nameexpr nil 'AND)
				(mk-sal-tupleliteral nil salexpr1 res)))))
        (num2salboolexpr number (cdr bits) salexpr2))))

;; number: list-of '(b1.TRUE). bits: '(b1 b2)
;; flag: if flag=TRUE, then return b1'=TRUE, otherwise b1=TRUE
(defun num2defns (number bits flag &optional (res nil))
  (if (null bits) res
      (let* ((bit0 (car bits))
	     (val0 (cdr (assoc bit0 number)))
	     (val1 (if val0 val0 'FALSE))
	     (lhs0 (mk-sal-nameexpr nil bit0))
	     (lhs1 (if flag (mk-sal-nextoperator nil lhs0) lhs0))
	     (rhs1 (mk-sal-rhsexpression nil (mk-sal-nameexpr nil val1)))
	     (defn1 (mk-sal-simpledefinition nil lhs1 rhs1)))
	(num2defns number (cdr bits) flag (cons defn1 res)))))
;; --------------------------------------------------------------------
 
;; --------------------------------------------------------------------
;; Miscellaneous Functions
;; --------------------------------------------------------------------
;; global-v2v-db: old-var-id (list of new-var-ids) (amap-identifiers-...)
(defun update-global-var2var-db (scalar-decls info)
  (declare (special *v2v-db*))
  (if (null scalar-decls) nil
      (let* ((var-id (id (car scalar-decls)))
	     (type-id (id (declared-type (car scalar-decls)))))
	(if (assoc var-id *v2v-db*) nil
	    (multiple-value-bind (amap digits) 
		(enum2bool (cdr (assoc type-id info)))
	      (setf *v2v-db* (acons var-id (cons digits amap) *v2v-db*))))
	(update-global-var2var-db (cdr scalar-decls) info))))

(defun scalar-type-decl? (decl)
  (and (type-declaration? decl) 
       (scalar-type? (type-expr decl))))

(defun scalar-var-decl? (decl info)
  (and (var-decl? decl) (assoc (id (declared-type decl)) info)))
;; --------------------------------------------------------------------

;; --------------------------------------------------------------------
;; Jul22,03: mk-sal-abstract-file1 copied from hsif3.0.lisp to here.
;; --------------------------------------------------------------------
(defun mk-sal-abstract-file1 (ctxtstr comment absctxt 
	&key (text "abstraction") (kind "sal") (pathname nil))
  (let ((filename (if pathname pathname
	(make-pathname :defaults ctxtstr :type kind :version :newest))))
    (if (not (open filename :direction :probe))
	(format t "Creating file ~A containing the ~A.~%" filename text)
	(format t "Renaming existing file to ~A.bak.~%" filename))
    (with-open-file (f filename :direction :output :if-exists :rename)
	(format f comment)
	(unparse absctxt :stream f)
	(format t "Created file ~A containing the ~A.~%" filename text)
	(close f))))
;; --------------------------------------------------------------------
