;;;;;;;;;;;;;;;;;;;;;;;;;;* -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vim: syntax=lisp
;; hsal-compose.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Wed Sep 11, 2002
;; Last Modified By: Ashish Tiwari
;; Last Modified On: Wed Sep 11, 2002
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY : 
;; 17/03/03: unparse buggy: prints LAMBDA(s). Therefore, defmethod apply-subst* 
;;	field-application has been hacked.
;;	Also, unparse prints -2 as (-)(2), which SAL doesn't like to parse.
;;	Hence, unary-minus-operator is mapped to difference operator!
;; 22/07/03: defpackage moved here.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(cl:defpackage "sal.hsal.preprocess"
  (:nicknames "hsal-preprocess")
  (:export "remove-definition")
  (:use "sal" "cl" "user" "clos"))

(in-package :sal)

(defmethod sal2sal-remove-definitions ((filename string) &rest garbage)
  (let ((salctxt (cond ((sal::file-exists-p filename)
	   		 (sal-parse filename))
	  		(t (sal::sal-error sal-file "File not found")))))
    (print2file (hsal-preprocess:remove-definition salctxt))))

(defmethod sal2sal-remove-definitions ((garbage t) &rest garbage1)
  (format t "Usage: (sal2sal-remove-definitions <filename>)~%"))

(defun print2file (c)
  (let* ((ctxtstr (concatenate 'string (symbol-name (id c)) "1"))
	 (comment "%% Automatically generated by remove-definitions.~%")
	 (f (make-pathname :defaults ctxtstr :type ".sal"))
	 (basename (pathname-name f)))
    (mk-sal-abstract-file1 basename comment c :text "Removed definitions" :kind ".sal")))
;; ============================================================================

(in-package "hsal-preprocess")

;; ============================================================================
(defmethod remove-definition ((salctxt context))
  (let* ((ctxtstr (concatenate 'string (symbol-name (id salctxt)) "1"))
	 (ctxtid  (make-symbol ctxtstr))
	 (params (mk-sal-parameters nil))
	 (ctxtbody (context-body salctxt))
	 (newdecls (mapcar #'remove-definition ctxtbody))
	 (newbody (apply #'mk-sal-contextbody nil newdecls)))
    (mk-sal-context nil ctxtid params newbody)))

(defmethod remove-definition ((moddecl module-declaration))
  (let* ((module (module moddecl))
	 (vardecls (apply #'mk-sal-vardecls nil (parameters moddecl)))
	 (modname (mk-sal-nameexpr nil (id moddecl)))
	 (newmodule (remove-definition module)))
  (mk-sal-moduledeclaration nil modname vardecls newmodule)))

(defmethod remove-definition ((module base-module))
  (let* ((olddecls (declarations module))
	 (defdecl (find-if #'def-decl? olddecls))
	 (defs (if defdecl (definitions defdecl)))
	 (x2c (def2subst defs))
	 (newdecls1 (mapcar #'(lambda(x) (apply-subst-decl x x2c)) olddecls))
	 (newdecls2 (remove-if #'null newdecls1))
         (last-var-decl (find-if #'var-decl? newdecls2 :from-end t)))
    ;(break)
    (if last-var-decl (setf (sal::chain? last-var-decl) nil))
    (apply #'mk-sal-basemodule nil newdecls2)))

(defmethod remove-definition ((module asynchronous-composition))
  module)
  ;(let ((nmod1 (remove-definition (module1 module)))
	;(nmod2 (remove-definition (module2 module))))
  ;(mk-sal-asynchronouscomposition nil nmod1 nmod2))

(defmethod remove-definition ((module synchronous-composition))
  module)

(defmethod remove-definition ((decl sal::type-declaration))
  decl)

(defmethod remove-definition ((decl t))
   (format t "Missing Code?~%") (break)
   decl)
;; ============================================================================

;; ============================================================================
;; apply-subst-decl: apply given substitution on the SAL decls!
;; Return value: nil if the SAL decl disappears, new SAL decl otherwise
;; ============================================================================
(defmethod apply-subst-decl ((vardecl sal::input-decl) x2c)
  vardecl)

(defmethod apply-subst-decl ((vardecl sal::output-decl) x2c)
  vardecl)

(defmethod apply-subst-decl ((vardecl sal::local-decl) x2c)
  (if (assoc (id vardecl) x2c :key #'id) nil vardecl))	;; NIL if present!!!

(defmethod apply-subst-decl ((defdecl sal::def-decl) x2c)
  nil)

(defmethod apply-subst-decl ((idecl sal::init-decl) x2c)
  (let* ((cmds (definitions-or-commands idecl))
	 (newcommands (mapcar #'(lambda(x) (apply-subst-decl x x2c)) cmds))
	 (gcs (loop for i in newcommands if (sal:guarded-command? i) collect i)) 
	 (defs (loop for i in newcommands if (not (sal:guarded-command? i)) collect i))
    	 (ngcs (apply #'mk-sal-somecommands nil gcs)))
    (apply #'mk-sal-initdecl nil (if gcs (cons ngcs defs) defs))))

(defmethod apply-subst-decl ((tdecl sal::trans-decl) x2c)
  (let* ((cmds (definitions-or-commands tdecl))
	 (newcommands (mapcar #'(lambda(x) (apply-subst-decl x x2c)) cmds))
	 (gcs (loop for i in newcommands if (sal:guarded-command? i) collect i)) 
    	 (ngcs (if gcs (apply #'mk-sal-somecommands nil gcs)))
	 (gpos (position-if #'sal:guarded-command? newcommands))
	 (defs (loop for i in newcommands as j upfrom 0
		 if (or (not (sal:guarded-command? i)) (eq j gpos)) collect i)))
    (if gpos (setf (nth gpos defs) ngcs))
    (apply #'mk-sal-transdecl nil defs)))

(defmethod apply-subst-decl ((def sal::simple-definition) x2c)
  (let* ((lhs (lhs def))
	 (old-expr (rhs-definition def))
	 (new-expr (apply-subst old-expr x2c))
	 (new-rhs (sal::mk-sal-rhsexpression nil new-expr)))
    (mk-sal-simpledefinition nil lhs new-rhs)))

(defmethod apply-subst-decl ((cmd sal::guarded-command) x2c)
  (let* ((old-guard (expression (guard cmd)))
	 (new-expr (apply-subst old-guard x2c))
	 (new-guard (mk-sal-guard nil new-expr))
	 (old-assgns (assignments cmd))
	 (new-assgns (mapcar #'(lambda(x)(apply-subst-decl x x2c)) old-assgns)))
    ;(break)
    (mk-sal-guardedcommand nil new-guard (apply #'mk-sal-assignments nil new-assgns))))

(defmethod apply-subst-decl ((decl sal::invar-decl) x2c)
  (format t "Invariant: Not doing")
  decl)

(defmethod apply-subst-decl ((decl t) x2c)
  (if (null x2c) (return-from apply-subst-decl decl))
  (format t "ERROR: Unidentified decl. Missing code. Please fill.~%")
  (break))
;; ============================================================================

;; ============================================================================
;; def2subst: definitions2substitution
;; ============================================================================
(defun def2subst (defs &optional (res nil))
  (if (null defs) res
      (let* ((lhs (lhs (car defs)))		;; name-expr with id
	     (rhs (rhs-definition (car defs))) 	;; rhs-selection!?
	     (rhs1 (apply-subst rhs res)))
	(def2subst (cdr defs) (acons lhs rhs1 res)))))
;; ============================================================================

;; ============================================================================
;; apply-subst: Input t, \sigma: Output: t\sigma
;; apply-subst*: Input t, \sigma. Output: t\sigma if t\sigma != t
;; Otherwise, it returns nil.
;; ============================================================================
(defun apply-subst (expr amap)
  (let* ((new-expr (apply-subst* expr amap)))
    (if new-expr new-expr expr)))

(defmethod apply-subst* ((expr name-expr) amap)	;; vars
  (cdr (assoc (id expr) amap :key #'id)))		;; NIL if absent!!
  ; the above is correct, but the following is a hack so that unparse works right!
  
(defmethod apply-subst* ((expr sal::tuple-literal) amap)
  (let ((new-exprs (loop for i in (sal:exprs expr) collect (apply-subst* i amap))))
    (if (every #'null new-exprs) nil
        (apply #'mk-sal-tupleliteral nil
	  (loop for i in new-exprs as j in (sal:exprs expr) collect (if i i j))))))

(defmethod apply-subst* ((expr sal::equation) amap)
  (break))

(defmethod apply-subst* ((expr sal::chained-conditional) amap)
  (let* ((cv1v2 (sal:exprs (sal:argument expr)))
	 (c1 (apply-subst* (car cv1v2) amap))
	 (v1 (apply-subst* (cadr cv1v2) amap))
	 (v2 (apply-subst* (caddr cv1v2) amap)))
    (if (every #'null (list c1 v1 v2)) (return-from apply-subst* nil))
    (sal::mk-sal-conditional '(sal:elsif? t sal:parens 0) (if c1 c1 (car cv1v2)) 
		(if v1 v1 (cadr cv1v2)) (if v2 v2 (caddr cv1v2)))))

(defmethod apply-subst* ((expr sal::conditional) amap)
  (let* ((cv1v2 (sal:exprs (sal:argument expr)))
	 (c1 (apply-subst* (car cv1v2) amap))
	 (v1 (apply-subst* (cadr cv1v2) amap))
	 (v2 (apply-subst* (caddr cv1v2) amap)))
    (if (every #'null (list c1 v1 v2)) (return-from apply-subst* nil))
    (sal::mk-sal-conditional nil (if c1 c1 (car cv1v2)) (if v1 v1 (cadr cv1v2)) 
				 (if v2 v2 (caddr cv1v2)))))
  
(defmethod apply-subst* :around ((expr sal::application) amap)
  (let ((ans (call-next-method)))
    (if ans (case (id (sal:operator expr))
	  ((+ - *) (setf (parens ans) 1)) (t nil)))
    (if (and ans (parens expr)) (setf (parens ans) 1))
    (if (and ans (eq (sal::id (sal::operator expr)) 'sal::IF)) (break))
    ans))

(defmethod apply-subst* ((expr sal::application) amap)
  (let* ((new-arg (apply-subst* (sal:argument expr) amap))
         (arglist (if (sal::tuple-literal? new-arg) (sal:exprs new-arg) (list new-arg))))
    (if (null new-arg) (return-from apply-subst* nil))
    (cond ((null arglist)		;; 0-ary
    	   (sal:mk-sal-application nil (sal::operator expr) new-arg))
	  ((null (cdr arglist))		;; 1-ary
	   (if  (and (sal-number-expr? (car arglist))
		     (sal:ps-eq (sal:operator expr) '-))
		(mk-sal-numberexpr (- 0 (sal-number-expr2number (car arglist))))
    	        (sal:mk-sal-application '(sal:infix? t) (sal:operator expr)
		  (sal:mk-sal-tupleliteral nil (mk-sal-numberexpr 0) (car arglist)))))
	  ((null (cddr arglist))	;; 2-ary
	   (let ((arg1 (car arglist)) (arg2 (cadr arglist)))
	     (cond ((and (sal-number-expr? arg1) (sal-number-expr? arg2))
		    (let ((n1 (sal-number-expr2number arg1)) 
			  (n2 (sal-number-expr2number arg2))
			  (op (sal:op2symbol (sal::operator expr))))
		      (cond ((eq op '<)
			     (sal:mk-sal-nameexpr nil (if (< n1 n2) 'sal:TRUE 'sal:FALSE)))
			    ((eq op '>)
			     (sal:mk-sal-nameexpr nil (if (> n1 n2) 'sal:TRUE 'sal:FALSE)))
			    ((eq op '<=)
			     (sal:mk-sal-nameexpr nil (if (<= n1 n2) 'sal:TRUE 'sal:FALSE)))
			    ((eq op '>=)
			     (sal:mk-sal-nameexpr nil (if (>= n1 n2) 'sal:TRUE 'sal:FALSE)))
			    ((eq op '+)
			     (mk-sal-numberexpr (+ n1 n2)))
			    ((eq op '-)
			     (mk-sal-numberexpr (- n1 n2)))
			    ((eq op '*)
			     (mk-sal-numberexpr (* n1 n2)))
			    ((eq op '/)
			     (mk-sal-numberexpr (/ n1 n2)))
			    ((eq op '=)
			     (sal:mk-sal-nameexpr nil (if (eq n1 n2) 'sal:TRUE 'sal:FALSE)))
			    (t (break) (sal:mk-sal-application nil (sal:operator expr) new-arg)))))
		   ((sal-number-expr? arg1)
		    (let ((n1 (sal-number-expr2number arg1)) 
			  (op (sal:op2symbol (sal::operator expr))))
		      (cond ((eq n1 0)
		      	     (cond ((eq op '+)
			     	    arg2)
			    	   ((eq op '*)
			     	    (mk-sal-numberexpr 0))
			    	   ((eq op '/)
			     	    (mk-sal-numberexpr 0))
			    	   (t (sal:mk-sal-application '(sal:infix? t) 
					(sal::operator expr) new-arg))))
			    ((eq n1 1)
		      	     (cond ((eq op '*)
			     	    arg2)
			    	   (t (sal:mk-sal-application '(sal:infix? t) 
					(sal::operator expr) new-arg))))
			    (t (sal:mk-sal-application '(sal:infix? t) 
					(sal::operator expr) 
				  	(sal::mk-sal-tupleliteral nil 
					  (sal-number-expr2pvs arg1) (cadr arglist)))))))
		   ((sal-number-expr? arg2)
		    (let ((n2 (sal-number-expr2number arg2))
			  (op (sal:op2symbol (sal:operator expr))))
		      (cond ((eq n2 0)
		      	     (cond ((eq op '+)
			     	    arg1)
			    	   ((eq op '*)
			     	    (mk-sal-numberexpr 0))
			    	   ((eq op '-)
			     	    arg1)
			    	   (t (sal:mk-sal-application '(sal:infix? t) 
					(sal::operator expr) new-arg))))
			    ((eq n2 1)
		      	     (cond ((eq op '*)
			     	    arg1)
			    	   (t (sal:mk-sal-application '(sal:infix? t) 
					(sal::operator expr) new-arg))))
			    ((eq op '/)
			     (sal:mk-sal-application '(sal:infix? t) (sal::times-operator)
				(sal:mk-sal-tupleliteral nil 
				  (mk-sal-numberexpr (/ 1 n2)) (car arglist))))
			    (t (sal:mk-sal-application '(sal:infix? t) (sal::operator expr)
				  (sal:mk-sal-tupleliteral nil (car arglist)
							       (sal-number-expr2pvs arg2)))))))
		   (t (sal:mk-sal-application '(infix? t) (sal::operator expr) new-arg)))))
	  (t				;; n-ary
	   (break) (sal:mk-sal-application nil (sal::operator expr) new-arg)))))

(defmethod apply-subst* ((expr sal::numeral) amap)		;; constants etc
  nil)

(defmethod apply-subst* ((expr t) amap)		;; constants etc
  (break)
  nil)
;; ========================================================================

(defun sal-number-expr? (expr)
  (or (sal::numeral? expr)
      (and (sal::infix-application? expr)
	   (sal::ps-eq (sal::operator expr) '/)
	   (sal::numeral? (sal::args1 expr))
	   (sal::numeral? (sal::args2 expr)))
      (and (sal::application? expr)
	   (sal::ps-eq (sal::operator expr) '-)
	   (sal-number-expr? (sal::args1 expr)))))

(defun sal-number-expr2number (expr)
  (cond ((sal::numeral? expr)
	 (sal::this-number expr))
	((sal::infix-application? expr)
         (/ (sal::number (sal::args1 expr)) (sal::number (sal::args2 expr))))
	(t ;; (sal::application? expr)
	 (- 0 (sal-number-expr2number (sal::args1 expr))))))

;; pure hack as a work-around for (-)(2/5), but it doesn't work either!
(defun sal-number-expr2pvs (expr)
  (cond ((sal::numeral? expr) 
	 expr)
	((sal::infix-application? expr)
	 expr)
	((sal::numeral? (sal::args1 expr))		;; -4
	 (mk-sal-numberexpr (sal-number-expr2number expr)))
	((sal::infix-application? (sal::args1 expr))	;; -(4/5)
	 (sal:mk-sal-application '(sal:infix? t) (sal::divides-operator) 
	   (sal:mk-sal-tupleliteral nil
	     (mk-sal-numberexpr (- 0 (sal-number-expr2number (sal::args1 (sal::args1 expr))))) 
	     (sal::args2 (sal::args1 expr)))))
	(t (sal-number-expr2pvs (sal::args1 (sal::args1 expr))))))

(defun mk-sal-numberexpr (n)
  (cond ((integerp n)
	 (sal::make-sal-instance 'sal::numeral nil 'sal::number n))
	((rationalp n)
	 (sal:mk-sal-application '(sal:infix? t) (sal::divides-operator)
	   (sal::mk-sal-tupleliteral nil 
	     (sal::make-sal-instance 'sal::numeral nil 'sal::number (numerator n))
	     (sal::make-sal-instance 'sal::numeral nil 'sal::number (denominator n)))))
	(t (format t "Unknown number~%") (break))))

