;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;* -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vim: syntax=lisp
;; sal-pvs2polyrep.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Wed Feb 06, 2002
;; Last Modified By: Ashish Tiwari
;; Last Modified On: Wed Feb 06, 2002
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY :
;; 03.08.02: Adding polyrep2pvs back translation function.
;; 03.23.02: Handling parameters in (defun polyrep2pvsPP...)
;; 05.07.02: Assing pvs2polyrepfml for translating atomic fmls.
;; 10.18.02: (x . c) x is now from (get-order)
;; 05.27.03: get-poly-rep* moved from hsal-compose to here.
;; 05.29.07: New version removes pvs altogether.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(provide 'polynomial-representation)
(cl:defpackage "pvs2polyrep"
 (:nicknames "pvs2prep")
 (:export "pvs2polyrep" "pvs2polyrepfml")
 (:use "polynomial-representation-core" "user" "cl" "clos"))

(in-package "pvs2polyrep")

;NOTE: (require prep:var-equal?, prep:get-order,
;; sal:args1, sal:args2, sal:op2symbol, sal:binary?)
;; These are defined in sal-extension.lisp in sal-typechecker

;; ==============================================================
;; Routines for UNIQUE polynomial representation
;; Ordering is assumed to be the multiset extension of the
;; LEXICOGRAPHIC ORDERING based on precedence *order* on monomials. 
;; *order* is a list of indeterminates.
;; get-poly-rep: 2x^2y ==> ((2 (x.2) (y.1)))
;; get-poly-rep: 2x^2y+1 ==> ((1) (2 (x.2) (y.1)))
;; ==============================================================
(defun pvs2polyrep (pol)
  (get-poly-rep* pol))

(defmethod get-poly-rep* ((pol sal:application))
  (let ((op (sal:op2symbol (sal:operator pol))))
    (cond ((eq op '*)
	   (let* ((p (sal:args1 pol))
		  (q (sal:args2 pol))
		  (prep (get-poly-rep* p))
		  (qrep (get-poly-rep* q)))
	     (polyrepMultiplyPoly prep qrep)))
	  ((eq op '+)
	   (let* ((p (sal:args1 pol))
		  (q (sal:args2 pol))
		  (prep (get-poly-rep* p))
		  (qrep (get-poly-rep* q)))
	     (polyrepAddPoly prep qrep)))
	  ((and (eq op '-) (sal:binary? pol))
	   (let* ((p (sal:args1 pol))
		  (q (sal:args2 pol))
		  (prep (get-poly-rep* p))
		  (qrep (get-poly-rep* q))
		  (minusqrep (polyrepNegativePoly qrep)))
	     (polyrepAddPoly prep minusqrep)))
	  ((eq op '-)
	   (let* ((p (sal:args1 pol))
		  (prep (get-poly-rep* p)))
	     (polyrepNegativePoly prep)))
	  ((eq op '/)
	   (let* ((p (sal:args1 pol))
		  (q (sal:args2 pol))
		  (prep (get-poly-rep* p))
		  (qrep (get-poly-rep* q)))
	     (polyrepMultiplyPoly prep (polyrepExpPolyCst qrep -1))))
	  (t 
	   (if  (sal:name-expr? (sal:operator pol))
		(get-poly-rep* (sal:operator pol))
	        (throw 'beyond-current-scope nil))))))

(defmethod get-poly-rep* ((pol sal:name-expr))
  (let ((v (find pol (prep:get-order) :test #'prep:var-equal?)))
    (if (null v) 
	(sal:sal-error t "ERROR: pvs2polyrep can't convert. Specify order first.~%"))
    (list (cons 1 (list (cons v 1))))))

(defmethod get-poly-rep* ((pol sal:numeral))
  (let ((n (sal:this-number pol)))
    (if (eq n 0) nil (list (list n)))))

(defmethod get-poly-rep* ((pol sal:expression))
  (sal:sal-error t "I don't know how to translate this to poly-rep~A~%" pol))
  ;(list (list 1))

;; ========================================================================
;; pvs2polyrepfml: input--pvs atomic formula, output--(poly . op)
;; where op is either '=, '>, '<. Others are error for now!
;; ========================================================================
(defun pvs2polyrepfml (pol)
  (pvs2polyrepfml* pol))
  
(defmethod pvs2polyrepfml* ((fmla sal:application))
  (let ((ope (sal:operator fmla)))
    ;; if (pvs:tc-eq (pvs:type (pvs::args1 fmla)) sal:*real*)
  	(let*  ((arg1 (sal:args1 fmla))
		(arg2 (sal:args2 fmla))
		(prep (get-poly-rep* arg1))
		(qrep (get-poly-rep* arg2))
		(minusqrep (polyrepNegativePoly qrep))
		(pol2 (polyrepAddPoly prep minusqrep))
		(op (sal:op2symbol ope)))
	  (cons pol2 op))))

(defmethod pvs2polyrepfml* ((pol t))
  (sal:sal-error t "PARAMETER: What is this?:~A" pol))
