;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;* -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vim: syntax=lisp
;; hsal-abs-piecewiselienar.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Thu Oct 31, 2002
;; Last Modified By: Ashish Tiwari
;; Last Modified On: Thu Oct 31, 2002
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY : 
;; 10.31.02: Piecewise Linear Abstraction: Using a DUAL representation.
;; 12.20.02: Introduced structure for cond-val.
;; 06.20.03: Bug in pol-cond-pdot2funcall corrected.
;; 09.25.03: pol-cond-pdot2funcall: if some cases of
;; 	IF-THEN-ELSE are unreachable, code still works.
;; 09.25.03: Same fn: (lambda(x y)(eq (prep:polyrepConstMultiple x y) 1))
;; 09.26.03: inamap ADDED. Input pols were being ignored!!!!!!
;; 01.27.04: bug:INV-call was o/p ONLY when there was an invariant.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package :sal.hsal.pl)

(defvar *p2cp-cache* nil)
(defstruct STATE flow cvps amap namap feasL dotinfo1 dotinfo2 assgns symtab E0 R0 S0)

(defmacro print-debug (level &rest others)
  `(if (and hsal-abs:*dlevel* (> ,level hsal-abs:*dlevel*))
       (funcall #'format ,@others)))

;; ============================================================================
;; Piecewise Continuous Hybrid System Case
;; Return Value: One guarded command.
;; For each poly p, p' IN IF (mode1) THEN ASS??() ELSIF and so on.
;; ============================================================================
;; decls---simple-definitions plus one guarded-command
;; amap----abstract variable.polynomial mapping
;; dotinfo1----poly.guarded-command.poly-list
;; dotinfo2----poly.guarded-command.??-list
;; symtab----conditions in guards and simple-definition symbol-table
;; db----database of pre-comuted abstractions of fmlas
(defun abstract-piecewise-system (module decls amap namap inamap feasL dotinfo1 dotinfo2 
				  assgns INV-call symtab db E0 R0 S0)
  (declare (special hsal-abs:*dlevel*))
  (print-debug 10 t "System identified as a Switched Dynamics Hybrid System....~%") ;; (break)
  (let* ((cont-dynamics0 (find-if #'sal:guarded-command? decls))
	 (cont-dynamics1 (sal.hsal:get-flow module (sal:assignments cont-dynamics0)))
	 (invariant0 (sal:expression (sal:guard cont-dynamics0)))
	 ;(invariant1 (find-if #'invar-decl? (declarations module)))
	 ;(invariant2 (if invariant1 (expression invariant1) nil))
	 (cvpairs (sal.hsal:get-condition-value-pair-list decls symtab))
	 (state (make-STATE :flow cont-dynamics1 :cvps cvpairs :amap amap :namap namap :feasL feasL
		:dotinfo1 dotinfo1 :dotinfo2 dotinfo2 :assgns assgns :symtab symtab :E0 E0 :R0 R0 :S0 S0)))
    (print-debug 2 t "Got the condition-value pairs.~%") ;; (break)
    (print-debug 8 t "Abstracting all conditions....~%")
    (multiple-value-bind (*lcache* gcache)
	 (abstract-formulas (sal.hsal:get-rhs-exprs decls) db symtab (append amap inamap))
      (declare (special *lcache*))
      (print-debug 8 t "Abstracting all conditions....Done.~%")
      (print-debug 8 t "Abstracting the invariant....~%")
      (multiple-value-bind (ainv1 db1) 
	(hsal-abs-fmla:sal-abstract-formula invariant0 db symtab (append amap inamap))	;; inamap ADDED!!!!
        (declare (ignore db1))
        (print-debug 8 t "Abstracting the invariant....Done.~%")
        (print-debug 8 t "Abstracting the continuous dynamics....~%")
        (values (list
          (sal:mk-sal-guardedcommand nil (sal:mk-sal-guard nil (combine-invs ainv1 INV-call))
	    (apply #'sal:mk-sal-assignments nil 
	      (get-abs-assgns state)))) gcache)))))

(defun combine-invs (inv1 inv2)
  (declare (special hsal-abs:*dlevel*))
  (cond ((and inv1 inv2)
	 ;(sal.hsal:mk-sal-bool (hsal-abs:afmla2sal inv1) (hsal-abs:afmla2sal inv2) sal:'AND)
	 (sal.hsal:mk-sal-bool (hsal-abs:afmla2sal inv1) inv2 sal:'AND))
	(inv1 (hsal-abs:afmla2sal inv1))
	(inv2 (hsal-abs:afmla2sal inv2))
	(t (print-debug 8 t "Error: Unreachable code.~%"))))

(defun get-abs-assgns (state)
  (loop for i in (STATE-amap state) collect (get-abs-assgn i state)))

(defun get-abs-assgn (p state)
  (declare (special hsal-abs:*dlevel*))
  (print-debug 4 t "calling get-abs-assgn with ~A~%" p)
  (let* ((a1 (car p))			;; p = (avar . pol)
	 (pol  (cdr p))
	 (pdot (prep:derivativeNewPol pol (STATE-flow state)))
	 (cv-list (pol2condpols pdot (STATE-cvps state) (hsal-abs:twoModes2OneMode (STATE-symtab state))))
	 (cond-funcalls0 (loop for i in cv-list if	;; for each case
			  (pol-cond-pdot2funcall a1 pol i state)
			  collect it))
	 ;(cond-funcalls1 (if (member nil cond-funcalls0)
			     ;(nconc (delete nil cond-funcalls0) 
				    ;(list (cons 'ELSE (pol2funcall pol cvps amap assgns symtab))))
			     ;cond-funcalls0))
	 (lhs (sal:mk-sal-nextoperator nil a1))
	 (rhs (cvpairs2nestedif cond-funcalls0)))
    ;;(break)
    (print-debug 4 t "returning from get-abs-assgn~%")
    (sal:mk-sal-simpledefinition nil lhs (sal:mk-sal-rhsselection nil rhs))))

(defun pol-cond-pdot2funcall (a1 pol cond-pdot state)
  (declare (special hsal-abs:*dlevel*))
  (let* ((index (cons (sal.hsal:CV-tt cond-pdot) (sal.hsal:CV-ff cond-pdot)))
	 (p1dot (hsal-abs:poltran2pdot pol index (STATE-dotinfo1 state) #'equal))
	 (p2dot (hsal-abs:poltran2pdot pol index (STATE-dotinfo2 state) #'equal)))
    ;; (break)
    (cond (p1dot
	   (print-debug 6 t " Derivative of ~A was explicitly added.~%" (prep:polyrepPrint pol))
	   (let* ((a1dot (car (rassoc (car p1dot) (STATE-amap state)))))
	     (setf (nth 0 (STATE-assgns state)) t)
	     (cons index (sal.hsal:get-funcall-assgn3 a1 a1dot t))))
	  ((and p2dot (numberp (car p2dot)))
	   (setf (nth 0 (STATE-assgns state)) t)
	   (print-debug 6 t " Derivative of ~A is a constant.~%" (prep:polyrepPrint pol))
	   (cons index (sal.hsal:get-funcall-assgn2 a1 (car p2dot))))
	  (p2dot
	   (print-debug 6 t " Derivative of ~A already existed.~%" (prep:polyrepPrint pol))
	   (let* ((a1dot (car (rassoc (car p2dot) (STATE-amap state))))
		  (sign  (eq (cadr p2dot) 1))
		  (a2 (if a1dot a1dot (car (rassoc (car p2dot) (STATE-amap state)
			:test #'(lambda(x y)(prep:polyrepConstMultiple? x y)))))))
  	     (setf (nth (if sign 0 1) (STATE-assgns state)) t)
	     (cons index (sal.hsal:get-funcall-assgn3 a1 a2 sign))))
	  (t	;; derivative unknown
	   (print-debug 6 t " Derivative of ~A unknown.~%" (prep:polyrepPrint pol))
	   (print-debug 6 t "  Mode-derivative=~A~%" (prep:polyrepPrint (sal.hsal:CV-val cond-pdot)))
	   ;; nil	OLD
  	   (let ((ER (cond-RAF2ER index (STATE-symtab state))))
	     (multiple-value-bind (st E R S) 
		(chaining-dp:saturate (car ER) (cadr ER) (caddr ER) nil (STATE-E0 state) (STATE-R0 state) (STATE-S0 state))
	       ;(print-debug 3 t "pol-cond-pdot2funcall: Saturation done~%")
	       (if (null st) 
		   (progn (print-debug 10 t "Some cases of ITE are inconsistent~%") nil)
		   (let ((Ac123 (hsal-abs-real:sal-abstract-expr-real0 (sal.hsal:CV-val cond-pdot) 
				(STATE-amap state) (STATE-namap state) (STATE-feasL state) E R S)))
	             ;(print-debug 3 t "pol-cond-pdot2funcall: sal-abstract-expr-real0 returned~%")
    	             (setf (nth (if (car Ac123) 4 5) (STATE-assgns state)) t)
    	             (cons index (sal.hsal:get-funcall-assgn5 a1 Ac123))))))))))

;; IF c1 THEN {pos} ELSIF c2 THEN {zero} ELSIF c3 THEN {neg} ELSE {p,n,z} ENDIF
;(defun pol2funcall (pol cvps amap assgns symtab)
  ;(let* ((vars (prep:allVarsIn pol))	;; all variables in pol
	 ;(relcvs (loop for i in cvps if (member (car i) vars :test #'prep:var-equal?) collect i))
    	 ;(cv-list (explode relcvs (list (cons (cons nil nil) pol))))
	 ;(cond-funcalls0 (loop for i in cv-list collect	;; for each case
			  ;(pol2funcall* i amap assgns symtab))))
    ;(cvpairs2nestedif cond-funcalls0)))

;(defun pol2funcall* (cond-pol amap assgns symtab)
  ;(let* ((ER (cond-RAF2ER (car cond-pol) symtab))
	 ;(Ac123 (hsal-abs-real:sal-abstract-expr-real0 
			;(cdr cond-pol) amap (car ER) (cdr ER))))
    ;(setf (nth (if (car Ac123) 2 3) assgns) t)
    ;(cons (car cond-pol) (sal.hsal:get-funcall-assgn4 Ac123))))

;; extract all real atomic formulas from E.F
(defun cond-RAF2ER (EF symtab)
  (let* ((ER0 (loop for i in (car EF) collect (hsal-abs-real:pvsfml2polyrep i symtab)))
  	 (ER1 (loop for i in (cdr EF) collect (hsal-abs-real:pvsfml2polyrepneg i symtab)))
	 ;; REi:  (= > >= <>) componentsFOUR parts
	 (E0  (loop for i in ER0 append (nth 0 i)))
	 (R0  (loop for i in ER0 append (nth 1 i)))
	 (S0  (loop for i in ER0 append (nth 2 i)))
	 (E1  (loop for i in ER1 append (nth 0 i)))
	 (R1  (loop for i in ER1 append (nth 1 i)))
	 (S1  (loop for i in ER1 append (nth 2 i))))
    (list (nconc E0 E1) (nconc R0 R1) (nconc S0 S1))))

;;
;(defun get-abs-assgn (p index dynamics cvps amap dotinfo1 dotinfo2 assgns symtab)
;  (let* ((a1 (car p))
	 ;(pol  (cdr p))
	 ;(p1dot (hsal-abs:poltran2pdot pol index dotinfo1))
	 ;(p2dot (hsal-abs:poltran2pdot pol index dotinfo2)))
    ;(cond (p1dot
	   ;(let* ((a1dot (car (rassoc (car p1dot) amap))))
	     ;(setf (nth 0 assgns) t)
	     ;(sal.hsal:mk-sal-quant-assgn3 a1 a1dot t)))
	  ;((numberp (car p2dot))
	   ;(setf (nth 0 assgns) t)
	   ;(sal.hsal:mk-sal-quant-assgn2 a1 (car p2dot)))
	  ;(p2dot
	   ;(let* ((a1dot (car (rassoc (car p2dot) amap)))
		  ;(sign  (eq (cadr p2dot) 1)))
  	     ;(setf (nth (if sign 0 1) assgns) t)
	     ;(sal.hsal:mk-sal-quant-assgn3 a1 a1dot sign)))
	  ;(t	;; derivative unknown
	   ;(format t "Derivative for ~A unknown.~%" pol)
	   ;(let* ((p1dot (prep:derivativeNewPol pol dynamics))
		  ;(vars (prep:allVarsIn p1dot))
		  ;(relcvs (loop for i in cvps if (member (car i) vars :test #'prep:var-equal?) collect i)))
	     ;(format t "poly is ~A~% relcvs is ~A~%" p1dot relcvs) ;; (break)
	     ;(exponential-cases a1 relcvs p1dot assgns index symtab amap))))))
;
;; Return avar IN IF c1 THEN ASS??() ELSIF c2 THEN ...
;; c1,c2: generated from exploding relcvs
;; ASS??() generated using sal-abstract-expr-real0
;(defun exponential-cases (avar relcvs p1dot assgns index symtab amap)
  ;(let* ((case-pols (explode relcvs (list (cons (cons nil nil) p1dot))))
	 ;(assgn-funcalls (loop for i in case-pols collect	;; for each case
			  ;(get-funcall-ppdot avar (cdr i) assgns index symtab amap)))
				;;; ASSV?123(avar,c1,c2,c3)
	 ;(lhs (sal:mk-sal-nextoperator nil avar))
	 ;(rhs (cvpairs2nestedif case-pols assgn-funcalls)))
    ;;;(break)
    ;(sal:mk-sal-simpledefinition nil lhs (sal:mk-sal-rhsselection nil rhs))))

(defun cvpairs2nestedif (funcalls)
  (declare (special *lcache*))
  (if (null (cdr funcalls)) (cdar funcalls)
      (sal:mk-sal-conditional nil (cond2salcond (caar funcalls) *lcache*)
		(cdar funcalls) (cvpairs2nestedif* (cdr funcalls) *lcache*))))

(defun cvpairs2nestedif* (funcalls lcache)
  (if (null (cdr funcalls)) (cdar funcalls)
      (sal:mk-sal-conditional '(sal:elsif? t) (cond2salcond (caar funcalls) lcache)
		(cdar funcalls) (cvpairs2nestedif* (cdr funcalls) lcache))))

;; If boolean: copy; if real-polynomials: then abstract
(defun cond2salcond (EdotF lcache)
  (let* ((atrueC (lcachelookup-list (car EdotF) lcache))
	 (afalseC (lcachelookup-list (cdr EdotF) lcache))
	 (asaltrueC (sal.hsal:mk-syntactic-bool* atrueC sal:'AND))	;; sal.hsal:AND
	 (asalfalseC (sal.hsal:mk-syntactic-bool* afalseC sal:'OR)))	;; sal.hsal:OR
    (sal.hsal:mk-sal-bool asaltrueC 
	(sal:mk-sal-application nil (sal:mk-sal-nameexpr nil sal:'NOT) 
	 (sal:mk-sal-tupleliteral nil asalfalseC)) sal:'AND)))
	
(defun lcachelookup-list (elist lcache)
  (loop for i in elist collect (lcachelookup-expr i lcache)))

(defun lcachelookup-listlist (ell lcache)
  (loop for i in ell collect (lcachelookup-list i lcache)))

(defun lcachelookup-expr (expr lcache)
  (if (hsal-abs:DNF-p expr) 
      (let ((ans (lcachelookup-listlist (hsal-abs:DNF-products expr) lcache)))
	(sal.hsal:mk-syntactic-bool* (loop for i in ans collect (sal.hsal:mk-syntactic-bool* i sal:'AND)) sal:'OR))
      (let ((ans (cdr (assoc expr lcache))))
	(if (null ans) (progn (format t "lcache lookup error. ~A not found.~%" expr) (break))) ans)))
;; index: gc; symtab: of terms; amap: abstraction mapping; avar: abs-var; pdot: real-expr
;(defun get-funcall-ppdot (avar pdot assgns index symtab amap)		;; ASSV?123(avar,c1,c2,c3)
  ;(let* ((Ac123 (hsal-abs-real:sal-abstract-expr-real pdot index symtab amap)))
    ;(setf (nth (if (car Ac123) 4 5) assgns) t)
    ;(sal.hsal:mk-sal-quant-funcall5 avar Ac123)))

;; Wrapper for explode!
(defun pol2condpols (pol cvps test)
  (declare (special *p2cp-cache*))
  (let* ((test-fn #'(lambda(x y)(eq (prep:polyrepConstMultiple? x y) 1)))
	 (cache (assoc pol *p2cp-cache* :test test-fn)))
    (if cache (return-from pol2condpols (cdr cache))))
  (let* ((vars (prep:allVarsIn pol))	;; all variables in pol
	 (relcvs (loop for i in cvps if (member (car i) vars :test #'prep:var-equal?) collect i))
    	 (cv-list (explode relcvs (list (sal.hsal:make-CV :tt nil :ff nil :val pol)) test)))
    (setf *p2cp-cache* (acons pol cv-list *p2cp-cache*))
    cv-list))

;; Return value: (cond . substituted-pol) -pairs.
;; cond: E . notE lists.
(defun explode (cond-value-pairs res test)
  (declare (special hsal-abs:*dlevel*))
  (print-debug 2 t "Exploding: LENGTH = ~A~%" (length cond-value-pairs))
  (print-debug 2 t "sal.hsal.pl::cond-value-pairs~%")
  (if (null cond-value-pairs) res
      (let* ((var (caar cond-value-pairs))
	     (cvs (cdar cond-value-pairs)))
	(explode (cdr cond-value-pairs)
	   (loop for i in cvs append 
		 (loop for j in res if (apply-substitution var i j test) collect it)) test))))

(defun apply-substitution (var cond-value cond-pol test)
  (declare (special hsal-abs:*dlevel*))
  (let* ((newE (sal.hsal:CV-tt cond-value))
	 (newF (sal.hsal:CV-ff cond-value))
	 (value (hsal-abs:RAF-pol (sal.hsal:CV-val cond-value)))
	 (oldE (sal.hsal:CV-tt cond-pol))
	 (oldF (sal.hsal:CV-ff cond-pol))
	 (oldpol (sal.hsal:CV-val cond-pol)))
    (multiple-value-bind (oneE oneF) (funcall test oldE oldF newE newF)
      (if (and (not (eq oneE -1)) (or (some #'listp oneE) (some #'listp oneF))) (break))
      (if (eq oneE -1) nil
	  (let ((newpol (prep:applySubstitution oldpol (list (cons var value)))))
    	    (print-debug 2 t "Old pol is ~A~%" oldpol)
    	    (print-debug 2 t "New pol is ~A~%" newpol)
    	    (print-debug 2 t "Var=~A and value=~A~%" var value)
    	    (sal.hsal:make-CV :tt oneE :ff oneF :val newpol))))))
;; ============================================================================

;; ============================================================================
;; Return value: New database + new local-cache
;; Argument: rhs-definitions of simple-defns and (expression of guards of gcs)
;; Algo: Use symtab to decipher the stack elements. This gives us ITE, RAF, BAF,
;; or DNFs. For first one, use local code, for others use "sal-abstract-formula".
;; ============================================================================
(defun abstract-formulas (stack db symtab amap)
  ;(format t "amap now IS ~a~%" amap)
  (abstract-formulas-list stack nil db symtab amap))
  
(defun abstract-formulas-list (stack lcache gcache symtab amap)
  (if (null stack) (values lcache gcache)
      (multiple-value-bind (local-cache global-cache)
	(abstract-formula* (car stack) lcache gcache symtab amap)
	(abstract-formulas-list (cdr stack) local-cache global-cache symtab amap))))

(defun abstract-formula* (expr lcache gcache symtab amap)
  (abstract-formula** (cdr (assoc expr symtab)) lcache gcache symtab amap))

;; Extension of sal-abstract-formula
(defmethod abstract-formula** ((expr sal.hsal.abs:ITE) lcache gcache symtab amap)
  (let* ((c (sal.hsal.abs:ITE-c expr))
	 (v1 (sal.hsal.abs:ITE-v1 expr))
	 (v2 (sal.hsal.abs:ITE-v2 expr)))
    (multiple-value-bind (ac gcache0)
	(hsal.abs.fmla:sal-abstract-formula c gcache symtab amap)
    (multiple-value-bind (lcache1 gcache1) 
	(abstract-formula* v1 lcache gcache0 symtab amap)
    (multiple-value-bind (lcache2 gcache2)
	(abstract-formula* v2 lcache1 gcache1 symtab amap)
      (values (acons c (sal.hsal.abs:afmla2sal ac) lcache2) gcache2))))))

(defmethod abstract-formula** ((expr t) lcache gcache symtab amap)
  (declare (ignore symtab amap))
  (values lcache gcache))	;; real values on leaf of ITEs OR guards.
;; ============================================================================
