;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;* -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vim: syntax=lisp
;; hsal-abs-pc-sat.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Thu Nov 07, 2002
;; Last Modified By: Ashish Tiwari
;; Last Modified On: : Thu Nov 07, 2002
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY : 
;; 11.07.02: Piecewise Continuous System: Saturation phase for it.
;; 12.13.02: BUG in using decideDynamicR corrected!
;; 02.10.02: BUG in const-multiple-new-new?* corrected. Recursive calls did
;; 	not set :key correctly!!
;; 09.25.03: derivativeNewPol result is now normalized.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; ============================================================================
;; ======== Hybrid Sal Abstractor Seed Polynomial Saturation Routines =========
;; ============================================================================
;; I use stuff off hsa.abs.sat directly---it should be moved to some common place.
;; RIGHT NOW: only *max-degree*

(in-package "sal.hsal.pc.sat")

;;(defvar *maxdegree* 2)

;; ============================================================================
;; Saturate pols: New data-struct. No pvs-exprs.
;; ============================================================================
(defun saturate-pols-new (symtab moddule seed-pols depth E0 R0 S0)
  (let* ((tdecl (find-if #'sal:trans-decl? (sal:declarations moddule)))
	 (datastruct (loop for i in seed-pols collect (list i 0 i)))
	 (new-seeds (remove-if #'(lambda(x) (nredundant? x (cons nil nil))) 
			datastruct :key #'(lambda(x) (cons (cadr x) (caddr x)))))
	 (transdecls (sal:definitions-or-commands tdecl))
	 (cont-trans (find-if #'sal.hsal:continuous-tran? transdecls))
	 (flow (sal.hsal:get-flow moddule (sal:assignments cont-trans)))	;; flow
	 (cvpairs (sal.hsal:get-condition-value-pair-list transdecls symtab))
	 (result (saturate-cvpl-flow-pols-d-wrap cvpairs flow new-seeds depth 
			symtab E0 R0 S0)))
    ;; (format t "Pols = ~A~%Rest = ~A~%" (car result) (cdr result))
    ;; (break)
    (values (car result) (cdr result))))

(defun saturate-cvpl-flow-pols-d-wrap (cvpl flow pols d symtab E0 R0 S0)
  (let ((*E0* E0) (*R0* R0) (*S0* S0) (*symtab* symtab))
    (declare (special *E0* *R0* *S0* *symtab*))
    (saturate-cvpl-flow-pols-d cvpl flow pols d (mergeToFirst pols (emptyDS)))))

;; Output: (values new-pols (cons pols rest))
(defun saturate-cvpl-flow-pols-d (cvpl flow pols d kres)
  (if (eq d 0) kres
      (multiple-value-bind (new-pols kres1)
		(saturate-cvpl-flow-pols-1 cvpl flow pols kres)
    	 (saturate-cvpl-flow-pols-d cvpl flow new-pols (- d 1) kres1))))

;; Many polynomial; get first derivative for "all" modes.
(defun saturate-cvpl-flow-pols-1 (cvpl flow pols kres &optional (new-pols nil))
  (if (null pols) (values new-pols kres)
      (multiple-value-bind (new-pols1 kres1)
	(saturate-cvpl-flow-pol-1 cvpl flow (caddar pols) kres)
	(saturate-cvpl-flow-pols-1 cvpl flow (cdr pols) kres1 (append new-pols1 new-pols)))))

;; One polynomial; get derivative for "all" modes.
(defun saturate-cvpl-flow-pol-1 (cvplist flow pol kres)
  (let ((cond-pols (get-derivative-cvpl-flow-pol-1 cvplist flow pol)))
    (multiple-value-bind (new-pols rest-pols) (separate-redundant cond-pols kres)	;; big-pols ignored
      (values new-pols (addToSecond-list pol rest-pols (addToFirst-list pol new-pols kres))))))
	 ;; (new-pols (remove-if #'(lambda(x) (nredundant? x kres)) cond-pols))
	 ;; (rest-big-pols (set-difference cond-pols new-pols))	;; can't destructively update here!
	 ;; (rest-pols (remove-if #'too-big? rest-big-pols))
	 ;; (kres1 (addToFirst-list pol new-pols kres))
	 ;; (kres2 (addToSecond-list pol rest-pols kres1))
    ;; (values new-pols kres2)

;; Input: cvplist: ( (E.F).0 (E.F).1 ...)
;; Input: flow: ( (var . nrep-poly) ... )
;; Input: pol: Nrep.poly
;; Output: ( (E1.F1).p1 ... (En.Fn).pn )
(defun get-derivative-cvpl-flow-pol-1 (cvps flow pol)
  (declare (special *symtab*))
  (let* ((p1dot (prep:derivativeNewPol pol flow))
	 (p2dot (chaining-dp::normalizePoly p1dot)))
    (sal.hsal.pl:pol2condpols p2dot cvps (hsal-abs:twoModes2OneMode *symtab*))))

(defun separate-redundant (cond-pols kres &optional (new nil) (old nil) (big nil))
  (if (null cond-pols) (values new old big)
      (let* ((this (car cond-pols))
	     (ER (cons (sal.hsal:CV-tt this) (sal.hsal:CV-ff this)))
	     (pol (sal.hsal:CV-val this)))
        (cond ((> (prep:polyrepTotalDegreePoly pol) (get-maxdegree))
	       (separate-redundant (cdr cond-pols) kres new old (cons this big)))
	      ((null pol)
	       (separate-redundant (cdr cond-pols) kres new (cons (cons ER (list 0 1)) old) big))
	      ((and (null (cdr pol)) (null (cdar pol)))
	       (cond ((> (caar pol) 0)
	              (separate-redundant (cdr cond-pols) kres new (cons (cons ER (list 1 1)) old) big))
		     ((= (caar pol) 0)
	              (separate-redundant (cdr cond-pols) kres new (cons (cons ER (list 0 1)) old) big))
		     (t
	              (separate-redundant (cdr cond-pols) kres new (cons (cons ER (list -1 1)) old) big))))
	      (t 
		(let ((ans (const-multiple-new-new?* pol (car kres) :key #'caddar)))
		  (if ans
	              (separate-redundant (cdr cond-pols) kres new (cons (cons ER ans) old) big)
		(let ((ans (const-multiple-new-new?* pol new :key #'cadar)))
		  (if ans
	              (separate-redundant (cdr cond-pols) kres new (cons (cons ER ans) old) big)
	              (separate-redundant (cdr cond-pols) kres (cons (list ER pol) new) old big))))))))))

;; SIDE EFFECT: cond-pol modified WHENEVER t returned!!! 
(defun nredundant? (cond-pol kres)
  (let ((pol (cdr cond-pol)))
    (cond ((> (prep:polyrepTotalDegreePoly pol) (get-maxdegree))
	   (format t " Derivative Polynomial exceeds maxdegree limit, Ignoring~%")
	   (setf (cdr cond-pol) 'BIG) t)
	  ((null pol)
	   (setf (cdr cond-pol) (list 0 1)) t)
	  ((and (null (cdr pol)) (null (cdar pol)))
	   (cond ((> (caar pol) 0)
		  (setf (cdr cond-pol) (list 1 1)) t)
		 ((= (caar pol) 0)
		  (setf (cdr cond-pol) (list 0 1)) t)
		 (t
		  (setf (cdr cond-pol) (list -1 1)) t)))
	  (t 
	   (let ((ans (const-multiple-new-new?* pol (car kres) :key #'caddar)))
	     (if ans (setf (cdr cond-pol) ans))
	     ans)))))

(defun too-big? (x)
  (eq (cdr x) 'BIG))

(defun addToFirst-list (pol new-pols kres)
  (if (null new-pols) kres
      (addToFirst-list pol (cdr new-pols) 
	(addToFirst (cons pol (car new-pols)) kres))))

(defun addToSecond-list (pol new-pols kres)
  (if (null new-pols) kres
      (addToSecond-list pol (cdr new-pols) 
	(addToSecond (cons pol (car new-pols)) kres))))

;; IDENTICAL to one from BEFORE. Move to common place?
(defun const-multiple-new-new?* (npol pollist &key (key #'caddar))
  (declare (special *E0* *R0* *S0*))
  (if (null pollist) (return-from const-multiple-new-new?* nil))
  (let* ((npol1 (funcall key pollist))
	 (soln (prep:polyrepConstMultiple? npol npol1)))	;; npol is not null
	;(format t "Trying ~A againt ~A~%" npol npol1)
	(if soln (return-from const-multiple-new-new?* (list npol1 soln)))
	(if (and (null *E0*) (null *R0*) (null *S0*))
	    (return-from const-multiple-new-new?* 
			 (const-multiple-new-new?* npol (cdr pollist) :key key)))
	(let* ((vars (prep:polyrepGetVariables npol))
	       (vars1 (prep:polyrepGetVariables npol1))
	       (vardiff (set-difference (car vars) (car vars1)
			:test #'prep:var-equal?))
	       (vardiff1 (set-difference (car vars1) (car vars)
				:test #'prep:var-equal?)))
	  (if (or vardiff vardiff1) 
	      (return-from const-multiple-new-new?* 
			   (const-multiple-new-new?* npol (cdr pollist) :key key)))
	  (if (not (chaining-dp:check-invariant-new npol 'chaining-dp::= npol1 'chaining-dp::= *E0* *R0* *S0*))
	      (return-from const-multiple-new-new?* 
			   (const-multiple-new-new?* npol (cdr pollist) :key key)))
	  (if (chaining-dp:check-invariant-new npol 'chaining-dp::> npol1 'chaining-dp::> *E0* *R0* *S0*)
	      (if (chaining-dp:check-invariant-new npol 'chaining-dp::< npol1 'chaining-dp::< *E0* *R0* *S0*)
		  (list npol1 1)
		  (const-multiple-new-new?* npol (cdr pollist) :key key))
	      (if (chaining-dp:check-invariant-new npol 'chaining-dp::> npol1 'chaining-dp::< *E0* *R0* *S0*)
	          (if (chaining-dp:check-invariant-new npol 'chaining-dp::< npol1 'chaining-dp::> *E0* *R0* *S0*)
		      (list npol1 -1)
		      (const-multiple-new-new?* npol (cdr pollist) :key key))
		  (const-multiple-new-new?* npol (cdr pollist) :key key))))))
;; ============================================================================

;; ============================================================================
;; Pair of list data-structure
;; ============================================================================
(defun emptyDS ()
  (cons nil nil))

(defun addToFirst (e1 p1)
  (cons (cons e1 (car p1)) (cdr p1)))

(defun addToSecond (e1 p1)
  (cons (car p1) (cons e1 (cdr p1))))

(defun join (p1 p2)
  (cons (append (car p1) (car p2))
	(append (cdr p1) (cdr p2))))

(defun mergeToFirst (l1 p1)
  (cons (append l1 (car p1))
	(cdr p1)))

(defun mergeToSecond (l1 p1)
  (cons (car p1) 
	(append l1 (cdr p1))))

(defun empty? (p1)
  (if (null p1) t
      (and (eq nil (car p1)) (eq nil (cdr p1)))))

(defun firstEmpty? (p1)
  (eq nil (car p1)))
;; ============================================================================

;; ============================================================================
(defun get-maxdegree ()
  hsal-abs-sat::*maxdegree*)
;; ============================================================================
