#!/bin/sh

#
# This script is used to install HybirdSal2.0 
#

echo "Installing HybridSAL (version 2.0). Copyring (c) SRI International 2003."
echo "---------------------------------------------------------------------"

check_prog ()
{
		if $1 > /dev/null 2> /dev/null ; then
				echo "program $2 was found..."
		else
				echo "Error: Failed to detect program $2"
				exit -1
		fi
}

check_prog "sed --version" sed
# check_prog "gcc --version" gcc
# check_prog "chmod --version" chmod

# if [ $# -eq 0 ] 
# then
#  echo "Warning: the target directory prefix was not specified. Using '/usr/local'."
#  prefix="/usr/local"
# else
#  if [ $# -eq 1 ] 
#  then
#    prefix=$1
#  else
#    echo "Error: invalid number of arguments."
#    echo "Usage: ./install.sh [target directory prefix]."
#    echo "Example: ./install.sh /usr/local"
#    exit -1
#  fi
# fi

salenv_dir=`pwd`

echo "Installation summary:"
echo "  HybridSAL_ABS directory: $salenv_dir"
# echo "  Binaries will be copied to: $prefix/bin"
warning=0

# make_dir ()
# {
#		if mkdir -p $1
#		then
#				echo "Directory $1 is present"
#		else
#				echo "Warning: Failed to create directory \"$1\"."
#				warning=1
#		fi
# }

# echo "Creating directories..."
# make_dir $prefix/bin

gen_script ()
{
  template=$1.template
  script=$1
  if sed -e "s|__HYBRIDSAL_ABS__|$salenv_dir|g" $template > $script
  then
		echo "Updated $script"
		# chmod +x $script
		# I will copy the files to $prefix/bin
		#	executable=$prefix/bin/$1-2.0
		#	if cp $script $executable
		#	then
		#			echo "Executable $executable was created."
		#	else
		#			echo "Warning: Failed to create the executable file at $prefix/bin"
    #      warning=1
		#	fi
	else
     echo "Error: generating script $script"
		 exit -1
  fi
}

# echo "Generating auxiliary scripts..."
for name in load.lisp load-lf.lisp dp/Makefile ; do gen_script $name; done

# echo "Generating uninstallation script..."
# if sed -e "s|__prefix__|$prefix|g" uninstall.sh.template > uninstall.sh
# then
#		chmod +x uninstall.sh
#		echo "Uninstallation script was generated."
# else
#		echo "Error generating uninstallation script."
#		exit -1
# fi

echo "Installation completed!"
# if [ $warning -eq 1 ]
# then 
#  echo "Warning: It was not possible to install SALenv at $prefix/bin, but you can execute it locally."
# echo "You can start SALenv typing: $salenv_dir/bin/salenv"
# echo "It is also a good idea to add the directory $salenv_dir/bin to your command search PATH environment variable."
# else
#	echo "You can start SALenv typing: $prefix/bin/salenv-2.0"
# fi

