;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;* -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vim: syntax=lisp
;; sal-hybrid-files.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Wed Jun 19, 2002
;; Last Modified By: Ashish Tiwari
;; Last Modified On: Thu Jun 20, 2002
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY :
;; 06/19/02: Create (auxiliary) files to be used with the model-checker. 
;; 07/08/02: some changes to mk-sal-abstract-file to make it generally useful.
;; 07/09/02: Added one line in fileABSAux.lisp .
;; 07/09/02: copy-generic-code-to-file function added.
;; 08/27/02: bug corrected in mk-lisp-aux-file, printing 'nil!!.
;; 11/20/02: new argument in mk-list-aux-file: S0
;; 12/04/02: changed #f to #t: new change in model-checker
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "sal.hsal")

;; ==============================================================
;; Create the .SAL file containing the abstract sal module.
;; ==============================================================
(defun mk-sal-abstract-file (absctxt amap
	&key (text "abstraction") (kind "sal") (pathname nil))
  (let* ((ctxtstr (symbol-name (id absctxt)))
	 (filename (if pathname pathname
	 (make-pathname :defaults ctxtstr :type kind :version :newest)))
	 (comment (format nil "%% Abstract variable to Polynomial Mapping:~%~A~%" (toString amap))))
    (if (not (open filename :direction :probe))
	(format t "Creating file ~A containing the ~A.~%" filename text)
	(format t "Renaming existing file to ~A.bak.~%" filename))
    (with-open-file (f filename :direction :output :if-exists :rename)
	(format f comment)
	(unparse absctxt :stream f)
	(format t "Created file ~A containing the ~A.~%" filename text)
	(close f))))

;; ==============================================================
;; make the lisp (input-specific) file. This lisp file should
;; define *allpols*, *order*, *parameters*, *parampols*.
;; It is called <contextName>ABSAux.lisp
;; ==============================================================
(defun mk-lisp-aux-file (cid varList paramList polList E0 R0 S0)
  (let* ((ctxtstr (concatenate 'string (symbol-name cid) "ABSAux"))
	 (filename (concatenate 'string ctxtstr ".lisp"))
	 (*gensym-counter* 0))
    (if (not (open filename :direction :probe))
	(format t "Creating file ~A containing the input-specific code.~%" filename)
	(format t "File ~A exists. Creating a new version.~%" filename))
    (with-open-file (f filename :direction :output :if-exists :rename)
	  (write-to-file f varList paramList polList E0 R0 S0)
	  (close f))))

(defun write-to-file (f varList paramList polList E0 R0 S0)
  (format f ";; vim: syntax=lisp~%")
  (format f ";; This file is automatically generated by abstract.~%")
  (format f ";; It defines *allpols*, *optimize*, *order*, *parameters*, etc.~%~%")
  (format f "(load \"~a/dp/server-new-full.fasl\")~%~%" sal::*sal-path*)
  (format f "(defconstant *order* '~A)~%" (if varList varList "()"))
  (format f "(defconstant *parameters* '~A)~%" (if paramList paramList "()"))
  (format f "(defconstant *optimize* t)~%")
  (write-all-pols f polList)
  (format f "(defconstant *allpols* (list ")
  (loop for i in polList collect (format f "~A " (car i)))
  (format f "))~%~%")
  (format f "(defvar *E0* '~A)~%" 
	(if E0 (loop for i in E0 collect (removeParens (chaining-dp::POL-pol i))) "()"))
  (format f "(defvar *R0* '~A)~%" 
	(if R0 (loop for i in R0 collect (removeParens (chaining-dp::POL-pol i))) "()"))
  (format f "(defvar *S0* '~A)~%" 
	(if S0 (loop for i in S0 collect (removeParens (chaining-dp::POL-pol i))) "()"))
  ;(format f "(defconstant *parampols* '~A)~%" (if parPolInds parPolInds "()"))
  ;(format f "(defconstant *parampols* '~A)~%" (if parPolInds parPolInds "()"))
  (format t "Created file containing the input-specific lisp code.~%"))

;; return a new name g5, given argument 5. pols is *amap2*
(defun write-all-pols (f pols)
  (loop for i in pols do
      (format f "(defconstant ~A '~A)~%" (car i) (removeParens (cdr i)))))

;; ==============================================================
;; make the scheme (input-specific) file. This scheme file should
;; define g0, g1, ..., and a function called invariant-check.
;; It is called <contextName>ABSAux.scm
;; ==============================================================
(defun mk-scm-aux-file (cid polList)
  (let* ((ctxtstr (concatenate 'string (symbol-name cid) "ABSAux"))
	 (filename (concatenate 'string ctxtstr ".scm")))
    (if (not (open filename :direction :probe))
	(format t "Creating file ~A containing the input-specific code.~%" filename)
	(format t "File ~A exists. Renaming old file.~%" filename))
    (with-open-file (f filename :direction :output :if-exists :rename)
	  (write-scm-to-file f polList)
	  (close f))))

(defun write-scm-to-file (f pols)
  (format f ";; vim: syntax=scm~%")
  (format f ";; This file is automatically generated by abstract.~%")
  (format f ";; It contains scheme code specific to this abstraction.~%~%")
  (copy-generic-code-to-file f)
  ;(format f "(load \"/homes/tiwari/sal/sal-devel/dp/sal-hybrid-aux.scm\")~%")
  (loop for i in pols collect (format f "(define ~A #unspecified)~%" (car i)))
  (format f "~%")
  (format f "(define (invariant-check main-module)~%")
  (format f "  (if (eq? ~A #unspecified)~%" (caar pols))
  (format f "      (begin~%")
  (loop for i in pols do 
  (format f "~0,8T(set! ~A (sal/module-get-variable main-module '~A #t))~%"
	 (car i) (car i)))
  (format f "      ))~%")
  (format f "  (let ((this-state (build-state-vector~%")
  (format f "~9,8T(list ")
  (loop for i in pols collect (format f "~A " (car i)))
  (format f ") '())))~%")
  (format f "    (check-consistency this-state)))~%"))

(defun copy-generic-code-to-file (f)
  (with-open-file (f1 (format nil "~a/composition/sal-hybrid-aux.scm" sal::*sal-path*)
			:direction :input)
    (let ((*eof* nil) (*linestr* "Ashish"))
      (declare (special *eof*))
      (declare (special *linestr*))
      (loop do
	(multiple-value-bind (linestr eof) (read-line f1 nil (values -1 -1))
	  (if (not (eq linestr -1)) (write-line linestr f)) 
	  (setf *eof* eof) (setf *linestr* linestr))
	while (and (not *eof*) (not (eq *linestr* -1)))))))

(defun removeParens (poly)
  (mapcar #'removeParensMono poly) poly)
(defun removeParensMono (mono)
  (mapcar #'removeParensPP (cdr mono)))
(defun removeParensPP (pp)	;; parameters are symbols!!
  (if (not (symbolp (car pp))) (setf (sal:parens (car pp)) 0)))

(defun toString (amap &optional (res ""))
  (if (null amap) res
      (toString (cdr amap) (concatenate 'string res 
	(format nil "%% ~A --> ~A~%" (caar amap) (prep:polyrepPrint (cdar amap)))))))
