;; vim: syntax=sch
;; This file contains generic scheme code.
;; This file gets loaded by the input-specific scheme file
;; created by abstract.

(define lookup-table '*)	;; Cache for storing already computed results

(define (check-consistency this-state)
  (let* ((cache-result (lookupState this-state lookup-table)))
    (if (eq? cache-result '*)
	(let* ((hostname (getenv "HOSTNAME"))
	       (socket (make-client-socket hostname 12321)) ;;[buffer-size [line-translation]]
	       (outport (socket-output socket))) ;;[buffer-size [line-translation]] 
    	  (send-state this-state outport)
    	  ;(print "Finished sending state vector.")
    	  (let ((answer (get-result socket)))
      	    (socket-shutdown socket)
	    (set! lookup-table (insertStateValuePair this-state answer lookup-table))
      	    answer))
	(begin
	  ;(print "Cached Value Found!!")
	  cache-result))))	;; Call decision procedure

;; build-state-vector: reverses the state!!
(define (build-state-vector state-variables res)
  (if (null? state-variables) res
      (build-state-vector (cdr state-variables) 
		(cons (sal/module-variable-value (car state-variables)) res))))
     
;; send this state over the open socket
(define (send-state this-state outport)
  (let ((port outport))
    (write-char #\A port)	;; SIGNAL BEGINNING
    (flush-output-port outport)
    (send-state* this-state port)
    (flush-output-port outport)))

(define (send-state* this-state port)
  (if (null? this-state)
      (write-char #\Z port)	;; SIGNAL END
      (begin
	(write-char (encode (car this-state)) port)
        (flush-output-port port)
	(send-state* (cdr this-state) port))))
      
;; (with-output-to-port port write)
;; encode: pos => p; neg => n; zero => z
(define (encode value)
  (cond ((eq? value 'pos) #\+)
	((eq? value 'neg) #\-)
	(#t #\0)))

;; Get result from the socket
(define (get-result socket)
  (let* ((inport (socket-input socket))
	 (inchar (read-char inport)))
    (print "Got answer " inchar)
    (if (eq? inchar #\T) #t #f)))


;; ===============================================================
;; Data-structure to cache results from decision procedure
;; ===============================================================
(define (insertStateValuePair feas value ds)
  (cond ((null? feas)
	 value)
	((eq? ds '*)
	 (cond ((eq? (car feas) 'pos)
		(list (insertStateValuePair (cdr feas) value '*) '* '*))
	       ((eq? (car feas) 'zero)
		(list '* (insertStateValuePair (cdr feas) value '*) '*))
	       (#t
		(list '* '* (insertStateValuePair (cdr feas) value '*)))))
	((eq? (car feas) 'pos) 
	 (list (insertStateValuePair (cdr feas) value (car ds)) (cadr ds) (caddr ds)))
	((eq? (car feas) 'zero) 
	 (list (car ds) (insertStateValuePair (cdr feas) value (cadr ds)) (caddr ds)))
	(#t
	 (list (car ds) (cadr ds) (insertStateValuePair (cdr feas) value (caddr ds))))))

(define (lookupState state ds)
  (cond ((eq? ds '*) '*)		;; Unknown 
	((null? state) ds)
	((eq? (car state) 'pos)
	 (lookupState (cdr state) (car ds)))
	((eq? (car state) 'zero)
	 (lookupState (cdr state) (cadr ds)))
	(#t
	 (lookupState (cdr state) (caddr ds)))))
;; ===============================================================
