;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------

;;;;;;;;;;;;;;;;;;;;;;;;;;* -*- Mode: Lisp -*- ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; vim: syntax=lisp
;; hsal-abs-mksal.lisp --
;; Author          : Ashish Tiwari
;; Created On      : Sat Oct 19, 2002
;; Last Modified By: Ashish Tiwari
;; Last Modified On: Sat Oct 19, 2002
;; Update Count    : 0
;; Status          : Unknown, use with caution
;;
;; HISTORY : 
;; 10.19.02: RHSSelection Assignments and Functions.
;; 12.12.02: mk-sal-ASSVD123 --- made more correct, added more cases
;; 12.13.02: mk-sal-setexpression --> mk-sal-setlistexpression corrected.
;; 06.04.03: mk-sal-ASSVC123: CORRECTED
;; 11.09.10: Added function (defmethod mk-sal-prime ((guard sal::guard) nameexprs))
;;	called from hsal-compose:abstract-cont-tran
;; 11.11.10: Added mk-sal-disequation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "sal.hsal")

(defvar sal-pos (mk-sal-nameexpr nil 'pos))
(defvar sal-neg (mk-sal-nameexpr nil 'neg))
(defvar sal-zero (mk-sal-nameexpr nil 'zero))

;; ===============================================================
(defun mk-sal-bool (c1 c2 op)
  (mk-sal-application '(sal:infix? t)
	(mk-sal-nameexpr nil op)
	(mk-sal-tupleliteral nil c1 c2)))

(defun mk-sal-equation (avar sal-val)
  (mk-sal-application '(sal:infix? t)
    (mk-sal-nameexpr nil '=)
      (mk-sal-tupleliteral nil avar 
	(if (symbolp sal-val)
	    (mk-sal-nameexpr nil sal-val)
	    sal-val))))

(defun mk-sal-disequation (avar sal-val)
  (mk-sal-application '(sal:infix? t)
    (mk-sal-nameexpr nil '/=)
      (mk-sal-tupleliteral nil avar sal-val)))
;; ===============================================================

;; ===============================================================
;; mk-sal-prime : copy a sal expression to a primed version
(defmethod mk-sal-prime ((guard sal::guard) nameexprs)
  (let* ((agua1 (sal::expression guard))
	 (agua2 (mk-sal-prime agua1 nameexprs)))
    (setf (sal::expression guard) (mk-sal-bool agua1 agua2 sal:'AND))
    guard))
  
(defmethod mk-sal-prime ((expr sal::infix-application) nameexprs)
  (mk-sal-application '(sal:infix? t)
	(mk-sal-prime (sal:operator expr) nameexprs)
	(mk-sal-prime (sal:argument expr) nameexprs)))
  
(defmethod mk-sal-prime ((expr sal::name-expr) nameexprs)
  (if (member expr nameexprs)
      (sal::mk-sal-nextoperator nil expr)
      expr))

(defmethod mk-sal-prime ((expr sal::tuple-literal) nameexprs)
  (apply #'sal:mk-sal-tupleliteral nil 
	(loop for i in (sal:exprs expr) collect 
	      (mk-sal-prime i nameexprs))))

(defmethod mk-sal-prime ((expr t) nameexprs)
  (declare (ignore nameexprs))
  expr)
;; ===============================================================

;; ============================================================================
;; In case num=1 THEN (similarly for other cases)
;; var' = IF (var=pos or zero) THN {pos} ELSE {neg,zero}
;; ============================================================================
(defun mk-sal-quant-assgn2 (var num)
  (mk-sal-simpledefinition nil (mk-sal-nextoperator nil var)
	(mk-sal-rhsselection nil (get-funcall-assgn2 var num))))
  
(defun get-funcall-assgn2 (var num)
  (if (eq num 0) (mk-sal-setlistexpression nil var)
  (let* ((fn  (mk-sal-nameexpr nil 'ASSVP))
	 (var2 (mk-sal-nameexpr nil (if (eq num 1) 'pos 'neg))))
    (mk-sal-application nil fn 
	(mk-sal-tupleliteral nil var var2)))))

;; In case num=1 THEN (similarly for other cases)
;; var1' = IF (var1=pos) THN (IF (var2=pos) {pos} ELS {n,z}) ELSIF 
;;	      (var1=zero) THN {var2} ELSE (...)
(defun mk-sal-quant-assgn3 (var1 var2 num)
  (mk-sal-simpledefinition nil (mk-sal-nextoperator nil var1) 
  	(mk-sal-rhsselection nil (get-funcall-assgn3 var1 var2 num))))

(defun get-funcall-assgn3 (var1 var2 num)
  (mk-sal-application nil (mk-sal-nameexpr nil (if num 'ASSVP 'ASSVN))
	(mk-sal-tupleliteral nil var1 var2)))

;; av' = IF c1 {pos} ELSIF c2 {zero} ELSIF c3 {neg} ELSE {p,z,n}
(defun mk-sal-quant-assgn4 (Ac123 av)
  (mk-sal-simpledefinition nil (mk-sal-nextoperator nil av)
	(mk-sal-rhsselection nil (get-funcall-assgn4 Ac123))))

(defun get-funcall-assgn4 (Ac123)
  (let* ((flag (car Ac123))
	 (c123 (cdr Ac123))
	 (c1  (caar c123))	;; > or >=
	 (c2  (cdar c123))	;; = or NEQ
	 (c3  (cdr c123))	;; < or <=
	 (fn  (mk-sal-nameexpr nil (if flag 'ASSC123 'ASSD123))))
    (mk-sal-application nil fn 
			(mk-sal-tupleliteral nil c1 c2 c3))))

;; p' = IF (p=pos) THN 
;;		IF (pdotgeq0-con) THN {pos} ELSE {pos,zero}
;;	ELSIF (p=neg) THN
;;		IF (pdotleq0-con) THN {neg} ELSE {neg,zero}
;;	ELSE 
;;		IF (pdoteq0-con) THN {zero} 
;;		ELSIF pdotgeq0-con THN {pos}
;;		ELSIF pdotleq0-con THN {neg}
;;		ELSE {pos,neg,zero}
(defun mk-sal-quant-assgn5 (var Ac123)
  (mk-sal-simpledefinition nil (mk-sal-nextoperator nil var)
    (mk-sal-rhsselection nil (get-funcall-assgn5 var Ac123))))

(defun get-funcall-assgn5 (var Ac123)
  (let* ((flag (car Ac123))
	 (funname (if flag 'ASSVC123 'ASSVD123))
	 (c1 (caadr Ac123))
	 (c2 (cdadr Ac123))
	 (c3 (cddr Ac123)))
    (mk-sal-application nil (mk-sal-nameexpr nil funname)
      (mk-sal-tupleliteral nil var c1 c2 c3))))

;; for num=t: (similarly for num=nil)
;; if c1p (if c2pz p pz) elsif c1n (if c2nz n nz) else (if c2p p eif c2n n z)
(defun mk-sal-ASSV (num)
  (let* ((name (if num 'ASSVP 'ASSVN))
	 (sign (mk-sal-typename nil 'SIGN))
	 (var1 (mk-sal-nameexpr nil 'x0))
	 (var2 (mk-sal-nameexpr nil 'x1))
	 (x0decl (mk-sal-vardecl nil var1 sign))
	 (x1decl (mk-sal-vardecl nil var2 sign))
	 (argdecl (mk-sal-vardecls nil x0decl x1decl))
	 (boolean (mk-sal-typename nil 'BOOLEAN))
	 (restype (mk-sal-functiontype nil sign boolean))
	 (c2p (mk-sal-equation var2 sal-pos))
	 (c2z (mk-sal-equation var2 sal-zero))
	 (c2n (mk-sal-equation var2 sal-neg))
	 (c2pz (mk-sal-bool c2p c2z sal:'OR))
	 (c1p (mk-sal-equation var1 sal-pos))
	 (c1n (mk-sal-equation var1 sal-neg))
	 (c2nz (mk-sal-bool c2n c2z sal:'OR))
	 (pos sal-pos)
	 (neg sal-neg)
	 (zero sal-zero)
	 (p (mk-sal-setlistexpression nil pos))
	 (z (mk-sal-setlistexpression nil zero))
	 (n (mk-sal-setlistexpression nil neg))
	 (pz (mk-sal-setlistexpression nil pos zero))
	 (nz (mk-sal-setlistexpression nil neg zero))
	 (v1  (mk-sal-conditional nil (if num c2pz c2nz) p pz))
	 (v2  (mk-sal-conditional nil (if num c2nz c2pz) n nz))
	 (v3  (mk-sal-conditional nil (if num c2p c2n) p
		(mk-sal-conditional '(sal:elsif? t) (if num c2n c2p) n z)))
	 (rhs (mk-sal-rhsselection nil 
	 	(mk-sal-conditional nil c1p v1
			(mk-sal-conditional '(sal:elsif? t) c1n v2 v3)))))
    (mk-sal-constantdeclaration nil name argdecl restype rhs)))

;;ASSVC123: IF (p=pos) THN IF (pdot>=0) THN {pos} ELSE {pos,zero};; c1
;;ELSIF (p=neg) THN IF (pdot=<0) THN {neg} ELSE {neg,zero}	;; c2
;;ELSE IF (pdot=0) THN {zero} ELSIF (pdot>0) {pos} ELSE {neg}
(defun mk-sal-ASSVC123 ()
  (let* ((name 'ASSVC123)
	 (sign (mk-sal-typename nil 'SIGN))
	 (boolean (mk-sal-typename nil 'BOOLEAN))
	 (var (mk-sal-nameexpr nil 'x0))
	 (x0decl (mk-sal-vardecl nil var sign))
	 (p-con (mk-sal-nameexpr nil 'c1))	;; GEQ
	 (z-con (mk-sal-nameexpr nil 'c2))	;; NEQ
	 (n-con (mk-sal-nameexpr nil 'c3))	;; LEQ
	 (c1decl (mk-sal-vardecl nil p-con boolean))
	 (c2decl (mk-sal-vardecl nil z-con boolean))
	 (c3decl (mk-sal-vardecl nil n-con boolean))
	 (argdecl (mk-sal-vardecls nil x0decl c1decl c2decl c3decl))
	 (restype (mk-sal-functiontype nil sign boolean))
	 (conP (mk-sal-equation var sal-pos))
	 (conN (mk-sal-equation var sal-neg))
	 (pos sal-pos)
	 (neg sal-neg)
	 (zero sal-zero)
	 (p (mk-sal-setlistexpression nil pos))
	 (n (mk-sal-setlistexpression nil neg))
	 (z (mk-sal-setlistexpression nil zero))
	 (pz  (mk-sal-setlistexpression nil pos zero))
	 (nz  (mk-sal-setlistexpression nil zero neg))
	 (c2pz (mk-sal-bool p-con z-con sal:'OR))
	 (c2nz (mk-sal-bool n-con z-con sal:'OR))
	 (v1  (mk-sal-conditional nil conP
	      	(mk-sal-conditional nil c2pz p pz)
	      (mk-sal-conditional '(sal:elsif? t) conN
	      	(mk-sal-conditional nil c2nz n nz)
	        (mk-sal-conditional nil z-con z 
		  (mk-sal-conditional '(sal:elsif? t) p-con p n)))))
	 (rhs (mk-sal-rhsselection nil v1)))
    (mk-sal-constantdeclaration nil name argdecl restype rhs)))

;; p' = IF (p=pos) THN 
;;		IF (pdotgeq0-con) THN {pos} ELSE {pos,zero}	;; c1
;;	ELSIF (p=neg) THN
;;		IF (pdotleq0-con) THN {neg} ELSE {neg,zero}	;; c2
;;	ELSE 
;;		IF (pdotGEQ0 AND pdotleq0-con) THN {zero}
;;		ELSIF (pdotNEQ0 AND pdotgeq0-con) THN {pos}	;; c3
;;		ELSIF (pdotNEQ0 AND pdotleq0-con) THN {neg}
;;		ELSIF (pdotGEQ0) THN {pos,zero}
;;		ELSIF (pdotLEQ0) THN {neg,zero}
;;		ELSIF (pdotNEQ0) THN {neg,zero}
;;		ELSE {pos,neg,zero}
(defun mk-sal-ASSVD123 ()
  (let* ((name 'ASSVD123)
	 (sign (mk-sal-typename nil 'SIGN))
	 (boolean (mk-sal-typename nil 'BOOLEAN))
	 (var (mk-sal-nameexpr nil 'x0))
	 (x0decl (mk-sal-vardecl nil var sign))
	 (geq (mk-sal-nameexpr nil 'c1))	;; GEQ
	 (neq (mk-sal-nameexpr nil 'c2))	;; NEQ
	 (leq (mk-sal-nameexpr nil 'c3))	;; LEQ
	 (c1decl (mk-sal-vardecl nil geq boolean))
	 (c2decl (mk-sal-vardecl nil neq boolean))
	 (c3decl (mk-sal-vardecl nil leq boolean))
	 (argdecl (mk-sal-vardecls nil x0decl c1decl c2decl c3decl))
	 (restype (mk-sal-functiontype nil sign boolean))
	 ;; REST
	 (pos sal-pos)
	 (zero sal-zero)
	 (neg sal-neg)
	 (conP (mk-sal-equation var sal-pos))
	 (conN (mk-sal-equation var sal-neg))
	 (geqleq (mk-sal-bool geq leq sal:'AND))
	 (geqneq (mk-sal-bool geq neq sal:'AND))
	 (leqneq (mk-sal-bool leq neq sal:'AND))
	 (p (mk-sal-setlistexpression nil pos))
	 (z (mk-sal-setlistexpression nil zero))
	 (n (mk-sal-setlistexpression nil neg))
	 (pz  (mk-sal-setlistexpression nil pos zero))
	 (pn  (mk-sal-setlistexpression nil pos neg))
	 (pnz (mk-sal-setlistexpression nil pos zero neg))
	 (nz  (mk-sal-setlistexpression nil neg zero))
	 (rhs1 (mk-sal-conditional nil conP
		 (mk-sal-conditional nil geq p pz)
	       (mk-sal-conditional '(sal:elsif? t) conN 
		 (mk-sal-conditional nil leq n nz)
		 (mk-sal-conditional nil geqleq z
		 (mk-sal-conditional '(sal:elsif? t) geqneq p
		 (mk-sal-conditional '(sal:elsif? t) leqneq n 
		 (mk-sal-conditional '(sal:elsif? t) geq pz 
		 (mk-sal-conditional '(sal:elsif? t) leq nz 
		 (mk-sal-conditional '(sal:elsif? t) neq pn pnz)))))))))
	 (rhs0 (mk-sal-rhsselection nil rhs1)))
    (mk-sal-constantdeclaration nil name argdecl restype rhs0)))

(defun mk-sal-ASSC123 ()
  (let* ((name 'ASSC123)
	 (sign (mk-sal-typename nil 'SIGN))
	 (boolean (mk-sal-typename nil 'BOOLEAN))
	 (c1 (mk-sal-nameexpr nil 'c1))
	 (c2 (mk-sal-nameexpr nil 'c2))
	 (c3 (mk-sal-nameexpr nil 'c3))
	 (c1decl (mk-sal-vardecl nil c1 boolean))
	 (c2decl (mk-sal-vardecl nil c2 boolean))
	 (c3decl (mk-sal-vardecl nil c3 boolean))
	 (argdecl (mk-sal-vardecls nil c1decl c2decl c3decl))
	 (restype (mk-sal-functiontype nil sign boolean))
	 ;; REST
	 (pos (mk-sal-nameexpr nil 'pos))
	 (neg (mk-sal-nameexpr nil 'neg))
	 (zer (mk-sal-nameexpr nil 'zero))
	 (vpo (mk-sal-setlistexpression nil pos))
	 (vne (mk-sal-setlistexpression nil neg))
	 (vze (mk-sal-setlistexpression nil zer))
	 (pnz (mk-sal-setlistexpression nil pos neg zer))
	 (v1  (mk-sal-conditional nil c1 vpo
	 	(mk-sal-conditional '(sal:elsif? t) c2 vze 
	 	  (mk-sal-conditional '(sal:elsif? t) c3 vne pnz))))
	 (rhs (mk-sal-rhsselection nil v1)))
    (mk-sal-constantdeclaration nil name argdecl restype rhs)))

;; av' = IF geq&neq THEN {pos} ELSIF geq&leq {zero} ELSIF leq&neq {neg} 
;;	 ELSIF geq {pz} ELSIF leq {nz} ELSIF neq {pn} ELSE pzn
(defun mk-sal-ASSD123 ()
  (let* ((name 'ASSD123)
	 (sign (mk-sal-typename nil 'SIGN))
	 (boolean (mk-sal-typename nil 'BOOLEAN))
	 (geq (mk-sal-nameexpr nil 'c1))
	 (neq (mk-sal-nameexpr nil 'c2))
	 (leq (mk-sal-nameexpr nil 'c3))
	 (c1decl (mk-sal-vardecl nil geq boolean))
	 (c2decl (mk-sal-vardecl nil neq boolean))
	 (c3decl (mk-sal-vardecl nil leq boolean))
	 (argdecl (mk-sal-vardecls nil c1decl c2decl c3decl))
	 (restype (mk-sal-functiontype nil sign boolean))
	 ;; REST
	 (pos (mk-sal-nameexpr nil 'pos))
	 (neg (mk-sal-nameexpr nil 'neg))
	 (zer (mk-sal-nameexpr nil 'zero))
	 (p (mk-sal-setlistexpression nil pos))
	 (n (mk-sal-setlistexpression nil neg))
	 (z (mk-sal-setlistexpression nil zer))
	 (pn (mk-sal-setlistexpression nil pos neg))
	 (pz (mk-sal-setlistexpression nil pos zer))
	 (nz (mk-sal-setlistexpression nil neg zer))
	 (pnz (mk-sal-setlistexpression nil pos neg zer))
	 (geqleq (mk-sal-bool geq leq sal:'AND))
	 (geqneq (mk-sal-bool geq neq sal:'AND))
	 (leqneq (mk-sal-bool leq neq sal:'AND))
;; av' = IF geq&neq THEN {pos} ELSIF geq&leq {zero} ELSIF leq&neq {neg} 
;;	 ELSIF geq {pz} ELSIF leq {nz} ELSIF neq {pn} ELSE pzn
	 (v1  (mk-sal-conditional nil geqneq p
	      (mk-sal-conditional '(sal:elsif? t) geqleq z 
	      (mk-sal-conditional '(sal:elsif? t) leqneq n
	      (mk-sal-conditional '(sal:elsif? t) geq pz
	      (mk-sal-conditional '(sal:elsif? t) leq nz
	      (mk-sal-conditional '(sal:elsif? t) neq pn pnz)))))))
	 (rhs (mk-sal-rhsselection nil v1)))
    (mk-sal-constantdeclaration nil name argdecl restype rhs)))

(defun get-fundec (assgns)
  (let ((fundec1 (if (nth 0 assgns) (list (mk-sal-ASSV t))))
	(fundec2 (if (nth 1 assgns) (list (mk-sal-ASSV nil))))
	(fundec3 (if (nth 2 assgns) (list (mk-sal-ASSC123))))
	(fundec4 (if (nth 3 assgns) (list (mk-sal-ASSD123))))
	(fundec5 (if (nth 4 assgns) (list (mk-sal-ASSVC123))))
	(fundec6 (if (nth 5 assgns) (list (mk-sal-ASSVD123)))))
    (nconc fundec1 fundec2 fundec3 fundec4 fundec5 fundec6)))

