;; --------------------------------------------------------------------
;; HybridSAL
;; Copyright (C) 2006, SRI International.  All Rights Reserved.
;; 
;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.
;; 
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;; 
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
;; --------------------------------------------------------------------


;; NOTE: I use "sal" in everything BECAUSE SAL uses PVS, which EXPORTS <>, >=, <=, etc....which I share
;; between most files. Note: chaining-dp does not use SAL, and therefore, it has its own >=, etc.
;; See pvs-extension.lisp and EXPORT in there.
(cl:defpackage "sal.hsal"
  (:export "mk-syntactic-bool*" "mk-sal-equation" "module2moddecl" 
	"mk-sal-disequation" "sal-pos" "sal-neg" "sal-zero"
	"mk-sal-quant-assgn2" "mk-sal-quant-assgn3" "mk-sal-quant-assgn4" 
	"get-funcall-assgn2" "get-funcall-assgn3" "get-funcall-assgn4" "get-funcall-assgn5"
	"mk-sal-quant-assgn5" "get-fundec" 
	"mk-sal-abstract-file" "mk-lisp-aux-file" "mk-scm-aux-file" 
	"mk-syntactic-bool" "mk-sal-bool" "sal-parse-list" "this" 
	"mk-sal-prime"
	"hybrid-automaton?" "continuous-tran?" "get-guards" "dummy-variable?" "get-flow" 
	"piecewise-continuous?" "get-rhs-exprs" "get-conditions" "get-condition-value-pair-list"
	"make-CV" "CV-tt" "CV-ff" "CV-val")
  (:use "sal" "cl" "user" "clos"))

;; This was "sal.hsal.abstractor" before.
(cl:defpackage "sal.hsal.abs"
  (:nicknames "hsal-abs")
  (:export "RAF" "RAF-p" "RAF-pol" "RAF-op" "make-RAF"
	"BAF" "BAF-p" "BAF-var" "BAF-val" "BAF-sgn" "make-BAF"
	"DNF" "DNF-p" "DNF-products" "make-DNF" 
	"ITE" "ITE-p" "ITE-c" "ITE-v1" "ITE-v2" "make-ITE"
	"afmla2sal"		;; all related to DATASTRUCT move to one file included by all??!!
	"poltran2pdot" "twoModes2OneMode" "*dlevel*"
	"abstract*" "polynomials-in-property" "get-property");; hsal-abs-real uses these.
  (:use "sal" "cl" "clos" "user"))

(cl:defpackage "sal.hsal.piecewiselinear"
  (:nicknames "sal.hsal.pl")
  (:use "sal" "cl" "clos" "user")
  (:export "abstract-piecewise-system" "pol2condpols"))

(cl:defpackage "sal.hsal.pc.sat"
  (:nicknames "sal-hsal-pc-sat")
  (:use "sal" "cl" "clos" "user")
  (:export "saturate-pols-new"))

(cl:defpackage "hsal-abstractor-saturation"
  (:nicknames "hsal-abs-sat")
  (:export "saturate-pols-new" "set-maxdegree")
  (:use "sal" "decision-procedure-core" "cl" "user" "clos"))

(cl:defpackage "hsal-abstract-real-expression"
  (:nicknames "hsal-abs-real")
  (:export "sal-abstract-expr-real" "sal-abstract-expr-real0" "pvsfml2polyrep" "pvsfml2polyrepneg")
  (:use "polynomial-representation-core" "decision-procedure-core"
	"sal" "cl" "user" "clos"))

(cl:defpackage "hsal-abstractor-formula"
  (:nicknames "hsal-abs-fmla" "hsal.abs.fmla")
  (:export "sal-abstract-formula")
  (:use "cl" "user" "clos" "sal" "hsal-abs"))

(cl:defpackage "hsal-abs-db"
  (:export "build-database" "seed-database" "getRAFsFromDB")
  (:use "sal" "cl" "user" "clos"))

(in-package "hsal-abs")
(defstruct BAF var val sgn)	;; Boolean atomic formula
(defstruct RAF pol op)		;; Real atomic formula
(defstruct DNF products)	;; Disjunctive Normal Form
(defstruct ITE c v1 v2)		;; If c THEN v1 ELSE v2
(defstruct RES amod adecls amap order parameters E0 R0 S0);; Result of abstraction

